/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.devui;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.moderation.Categories;
import dev.ai4j.openai4j.moderation.CategoryScores;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import dev.langchain4j.internal.RetryUtils;
import io.quarkiverse.langchain4j.openai.runtime.config.LangChain4jOpenAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;

public class OpenAiModerationModelsJsonRPCService {
    @Inject
    LangChain4jOpenAiConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject moderate(String configuration, String modelName, String prompt) {
        if (NamedModelUtil.isDefault((String)configuration) && this.config.defaultConfig().apiKey().equals("dummy")) {
            throw new RuntimeException("OpenAI API key is not configured. Please specify the key in the `quarkus.langchain4j.openai.api-key` configuration property.");
        }
        LangChain4jOpenAiConfig.OpenAiConfig clientConfig = NamedModelUtil.isDefault((String)configuration) ? this.config.defaultConfig() : this.config.namedConfig().get(configuration);
        OpenAiClient client = OpenAiClient.builder().openAiApiKey(clientConfig.apiKey()).baseUrl(clientConfig.baseUrl()).callTimeout(clientConfig.timeout()).connectTimeout(clientConfig.timeout()).readTimeout(clientConfig.timeout()).writeTimeout(clientConfig.timeout()).build();
        try {
            ModerationRequest request = ModerationRequest.builder().model(modelName).input(prompt).build();
            ModerationResponse response = (ModerationResponse)RetryUtils.withRetry(() -> (ModerationResponse)client.moderation(request).execute(), (int)clientConfig.maxRetries());
            ModerationResult moderationResult = (ModerationResult)response.results().get(0);
            CategoryScores categoryScores = moderationResult.categoryScores();
            Categories categoryFlags = moderationResult.categories();
            JsonObject result = new JsonObject();
            result.put("flagged", (Object)moderationResult.isFlagged());
            JsonArray categories = new JsonArray();
            this.addCategoryScore(categories, "sexual", categoryScores.sexual(), categoryFlags.sexual());
            this.addCategoryScore(categories, "hate", categoryScores.hate(), categoryFlags.hate());
            this.addCategoryScore(categories, "hate-threatening", categoryScores.hateThreatening(), categoryFlags.hateThreatening());
            this.addCategoryScore(categories, "self-harm", categoryScores.selfHarm(), categoryFlags.selfHarm());
            this.addCategoryScore(categories, "violence", categoryScores.violence(), categoryFlags.violence());
            this.addCategoryScore(categories, "violence-graphic", categoryScores.violenceGraphic(), categoryFlags.violenceGraphic());
            this.addCategoryScore(categories, "sexual-minors", categoryScores.sexualMinors(), categoryFlags.sexualMinors());
            result.put("categories", (Object)categories);
            JsonObject jsonObject = result;
            return jsonObject;
        }
        finally {
            client.shutdown();
        }
    }

    private void addCategoryScore(JsonArray categories, String name, Double score, Boolean flagged) {
        if (score != null) {
            JsonObject categoryScore = new JsonObject();
            categoryScore.put("name", (Object)name);
            categoryScore.put("flagged", (Object)flagged);
            categoryScore.put("score", (Object)score);
            categories.add((Object)categoryScore);
        }
    }
}

