/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.runtime.devui;

import dev.langchain4j.data.image.Image;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiImageModel;
import io.quarkiverse.langchain4j.openai.runtime.config.LangChain4jOpenAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;
import java.util.Optional;

public class OpenAiImagesJsonRPCService {
    @Inject
    LangChain4jOpenAiConfig config;

    public JsonObject generate(String configuration, String modelName, String size, String prompt, String quality) {
        if (NamedModelUtil.isDefault((String)configuration) && this.config.defaultConfig().apiKey().equals("dummy")) {
            throw new RuntimeException("OpenAI API key is not configured. Please specify the key in the `quarkus.langchain4j.openai.api-key` configuration property.");
        }
        LangChain4jOpenAiConfig.OpenAiConfig clientConfig = NamedModelUtil.isDefault((String)configuration) ? this.config.defaultConfig() : this.config.namedConfig().get(configuration);
        QuarkusOpenAiImageModel model = QuarkusOpenAiImageModel.builder().baseUrl(clientConfig.baseUrl()).apiKey(clientConfig.apiKey()).timeout(clientConfig.timeout()).user(clientConfig.imageModel().user()).maxRetries(clientConfig.maxRetries()).persistDirectory(Optional.empty()).modelName(modelName).quality(quality).size(size).build();
        Image image = (Image)model.generate(prompt).content();
        JsonObject result = new JsonObject();
        result.put("prompt", (Object)prompt);
        if (image.url() != null) {
            result.put("url", (Object)image.url().toString());
        } else {
            result.put("url", null);
        }
        if (image.base64Data() != null && !image.base64Data().isEmpty()) {
            result.put("base64Data", (Object)image.base64Data());
        } else {
            result.put("base64Data", null);
        }
        return result;
    }
}

