/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import dev.ai4j.openai4j.OpenAiHttpException;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.openai.OpenAiApiException;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.quarkus.rest.client.reactive.NotBody;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParams;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;

@Path(value="")
@ClientHeaderParams(value={@ClientHeaderParam(name="Authorization", value={"Bearer {token}"}), @ClientHeaderParam(name="api-key", value={"{token}"})})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface OpenAiRestApi {
    @Path(value="completions")
    @POST
    public Uni<CompletionResponse> completion(CompletionRequest var1, @NotBody String var2);

    @Path(value="completions")
    @POST
    public CompletionResponse blockingCompletion(CompletionRequest var1, @NotBody String var2);

    @Path(value="chat/completions")
    @POST
    @RestStreamElementType(value="application/json")
    public Multi<CompletionResponse> streamingCompletion(CompletionRequest var1, @NotBody String var2);

    @Path(value="chat/completions")
    @POST
    public Uni<ChatCompletionResponse> createChatCompletion(ChatCompletionRequest var1, @NotBody String var2);

    @Path(value="chat/completions")
    @POST
    public ChatCompletionResponse blockingChatCompletion(ChatCompletionRequest var1, @NotBody String var2);

    @Path(value="chat/completions")
    @POST
    @RestStreamElementType(value="application/json")
    public Multi<ChatCompletionResponse> streamingChatCompletion(ChatCompletionRequest var1, @NotBody String var2);

    @Path(value="embeddings")
    @POST
    public Uni<EmbeddingResponse> embedding(EmbeddingRequest var1, @NotBody String var2);

    @Path(value="embeddings")
    @POST
    public EmbeddingResponse blockingEmbedding(EmbeddingRequest var1, @NotBody String var2);

    @Path(value="moderations")
    @POST
    public Uni<ModerationResponse> moderation(ModerationRequest var1, @NotBody String var2);

    @Path(value="moderations")
    @POST
    public ModerationResponse blockingModeration(ModerationRequest var1, @NotBody String var2);

    @ClientExceptionMapper
    public static RuntimeException toException(Response response) {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            return new OpenAiHttpException(response.getStatus(), (String)response.readEntity(String.class));
        }
        return null;
    }

    public static class OpenAiClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(OpenAiClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*sk-)(\\w{2})(\\w+)(\\w{2})");
        private final boolean logRequests;
        private final boolean logResponses;

        public OpenAiClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("Authorization")) {
                    headerValue = OpenAiClientLogger.maskAuthorizationHeaderValue(headerValue);
                } else if (headerKey.equals("api-key")) {
                    headerValue = OpenAiClientLogger.maskApiKeyHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }

        private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
            try {
                if (apiKeyHeaderValue.length() <= 4) {
                    return apiKeyHeaderValue;
                }
                return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    @Provider
    @ConstrainedTo(value=RuntimeType.CLIENT)
    public static class OpenAiRestApiWriterInterceptor
    implements WriterInterceptor {
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            Object entity = context.getEntity();
            if (entity instanceof ChatCompletionRequest) {
                ChatCompletionRequest request = (ChatCompletionRequest)entity;
                MultivaluedMap headers = context.getHeaders();
                List acceptList = (List)headers.get((Object)"Accept");
                if (acceptList != null && acceptList.size() == 1) {
                    String accept = (String)acceptList.get(0);
                    if ("application/json".equals(accept)) {
                        if (Boolean.TRUE.equals(request.stream())) {
                            context.setEntity((Object)ChatCompletionRequest.builder().from(request).stream(null).build());
                        }
                    } else if ("text/event-stream".equals(accept) && !Boolean.TRUE.equals(request.stream())) {
                        context.setEntity((Object)ChatCompletionRequest.builder().from(request).stream(Boolean.valueOf(true)).build());
                    }
                }
            }
            context.proceed();
        }
    }

    @Provider
    @ConstrainedTo(value=RuntimeType.CLIENT)
    public static class OpenAiRestApiReaderInterceptor
    implements ReaderInterceptor {
        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            try {
                return this.validateResponse(context.proceed());
            }
            catch (ProcessingException e) {
                Class targetType;
                Throwable cause = e.getCause();
                if (cause instanceof MismatchedInputException && (ChatCompletionResponse.Builder.class.equals((Object)(targetType = ((MismatchedInputException)cause).getTargetType())) || CompletionResponse.Builder.class.equals((Object)targetType)) && (cause.getMessage().contains("DONE") || cause.getMessage().contains("JsonToken.START_ARRAY"))) {
                    return null;
                }
                throw e;
            }
        }

        private Object validateResponse(Object result) {
            ModerationResponse r;
            if (result instanceof ChatCompletionResponse) {
                ChatCompletionResponse r2 = (ChatCompletionResponse)result;
                if (r2.id() == null) {
                    throw new OpenAiApiException(ChatCompletionResponse.class);
                }
            } else if (result instanceof CompletionResponse) {
                CompletionResponse r3 = (CompletionResponse)result;
                if (r3.id() == null) {
                    throw new OpenAiApiException(CompletionResponse.class);
                }
            } else if (result instanceof ModerationResponse && (r = (ModerationResponse)result).id() == null) {
                throw new OpenAiApiException(ModerationResponse.class);
            }
            return result;
        }
    }

    @Provider
    @ConstrainedTo(value=RuntimeType.CLIENT)
    @Priority(value=5100)
    public static class OpenAiRestApiJacksonProvider
    extends AbstractJsonMessageBodyReader
    implements MessageBodyWriter<Object> {
        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return ObjectMapperHolder.READER.forType(ObjectMapperHolder.READER.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(ObjectMapperHolder.MAPPER.writeValueAsString(o).getBytes(StandardCharsets.UTF_8));
        }

        public static class ObjectMapperHolder {
            public static final ObjectMapper MAPPER = QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
            private static final ObjectReader READER = MAPPER.reader();
        }
    }
}

