/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.testing.internal;

import io.quarkiverse.langchain4j.openai.testing.internal.ChatCompletionTransformer;
import io.quarkiverse.langchain4j.testing.internal.WiremockAware;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;

public abstract class OpenAiBaseTest
extends WiremockAware {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    static ObjectMapper mapper;
    private static final InstanceOfAssertFactory<Map, MapAssert<String, String>> MAP_STRING_STRING;
    private static final InstanceOfAssertFactory<Map, MapAssert<String, Object>> MAP_STRING_OBJECT;
    private static final InstanceOfAssertFactory<List, ListAssert<Map>> LIST_MAP;

    @BeforeAll
    static void beforeAll() {
        mapper = new ObjectMapper();
    }

    protected void setChatCompletionMessageContent(String content) {
        ChatCompletionTransformer.setContent(content);
    }

    @AfterEach
    public void restoreOriginalChatCompletionMessageContent() {
        ChatCompletionTransformer.clearContent();
    }

    protected Map<String, Object> getRequestAsMap() throws IOException {
        return this.getRequestAsMap(this.requestBodyOfSingleRequest());
    }

    protected Map<String, Object> getRequestAsMap(byte[] body) throws IOException {
        return (Map)mapper.readValue(body, MAP_TYPE_REF);
    }

    protected static void assertSingleRequestMessage(Map<String, Object> requestAsMap, String value) {
        OpenAiBaseTest.assertMessages(requestAsMap, listOfMessages -> ((MapAssert)Assertions.assertThat((List)listOfMessages).singleElement(Assertions.as(MAP_STRING_STRING))).satisfies(new ThrowingConsumer[]{message -> ((MapAssert)Assertions.assertThat((Map)message).containsEntry((Object)"role", (Object)"user")).containsEntry((Object)"content", (Object)value)}));
    }

    protected static void assertMultipleRequestMessage(Map<String, Object> requestAsMap, List<MessageContent> messageContents) {
        OpenAiBaseTest.assertMessages(requestAsMap, listOfMessages -> ((ListAssert)((ListAssert)Assertions.assertThat((List)listOfMessages).asInstanceOf(LIST_MAP)).hasSize(messageContents.size())).satisfies(new ThrowingConsumer[]{l -> {
            for (int i = 0; i < messageContents.size(); ++i) {
                MessageContent messageContent = (MessageContent)messageContents.get(i);
                Assertions.assertThat((Map)((Map)l.get(i))).satisfies(new ThrowingConsumer[]{message -> {
                    Assertions.assertThat((Map)message).containsEntry((Object)"role", (Object)messageContent.role());
                    if (messageContent.content() == null) {
                        if (message.containsKey("content")) {
                            Assertions.assertThat((Map)message).containsEntry((Object)"content", null);
                        }
                    } else {
                        Assertions.assertThat((Map)message).containsEntry((Object)"content", (Object)messageContent.content());
                    }
                }});
            }
        }}));
    }

    protected static void assertMessages(Map<String, Object> requestAsMap, Consumer<List<? extends Map>> messagesAssertions) {
        Assertions.assertThat(requestAsMap).hasEntrySatisfying((Object)"messages", o -> ((ListAssert)Assertions.assertThat((Object)o).asInstanceOf(InstanceOfAssertFactories.list(Map.class))).satisfies(new Consumer[]{messagesAssertions}));
    }

    protected static void assertSingleFunction(Map<String, Object> requestAsMap, String functionName) {
        OpenAiBaseTest.assertFunctions(requestAsMap, listOfMessages -> ((MapAssert)Assertions.assertThat((List)listOfMessages).singleElement(Assertions.as(MAP_STRING_OBJECT))).satisfies(new ThrowingConsumer[]{tool -> {
            ((MapAssert)Assertions.assertThat((Map)tool).containsEntry((Object)"type", (Object)"function")).containsKey((Object)"function");
            ((MapAssert)Assertions.assertThat(tool.get("function")).asInstanceOf(MAP_STRING_OBJECT)).containsEntry((Object)"name", (Object)functionName);
        }}));
    }

    protected static void assertFunctions(Map<String, Object> requestAsMap, Consumer<List<? extends Map>> functionAssertions) {
        Assertions.assertThat(requestAsMap).hasEntrySatisfying((Object)"tools", o -> ((ListAssert)Assertions.assertThat((Object)o).asInstanceOf(InstanceOfAssertFactories.list(Map.class))).satisfies(new Consumer[]{functionAssertions}));
    }

    static {
        MAP_STRING_STRING = InstanceOfAssertFactories.map(String.class, String.class);
        MAP_STRING_OBJECT = InstanceOfAssertFactories.map(String.class, Object.class);
        LIST_MAP = InstanceOfAssertFactories.list(Map.class);
    }

    public record MessageContent(String role, String content) {
    }
}

