/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.testing.internal;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;

public class ChatCompletionTransformer
implements ResponseDefinitionTransformerV2 {
    private static final String SYS_PROP_NAME = "quarkus.langchain4j.openai.chat-completion.message.content";

    public ResponseDefinition transform(ServeEvent serveEvent) {
        Parameters transformerParameters;
        ResponseDefinition rd = serveEvent.getResponseDefinition();
        String chatCompletionMessageContent = System.getProperty(SYS_PROP_NAME);
        if (chatCompletionMessageContent != null && (transformerParameters = rd.getTransformerParameters()) != null) {
            transformerParameters.put((Object)"ChatCompletionMessageContent", (Object)chatCompletionMessageContent);
        }
        return rd;
    }

    public String getName() {
        return "completion-transformer";
    }

    public static void setContent(String content) {
        System.setProperty(SYS_PROP_NAME, content);
    }

    public static void clearContent() {
        System.clearProperty(SYS_PROP_NAME);
    }
}

