/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.openai.deployment.devui;

import io.quarkiverse.langchain4j.deployment.items.SelectedImageModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedModerationModelProviderBuildItem;
import io.quarkiverse.langchain4j.openai.deployment.LangChain4jOpenAiBuildConfig;
import io.quarkiverse.langchain4j.openai.runtime.devui.OpenAiImagesJsonRPCService;
import io.quarkiverse.langchain4j.openai.runtime.devui.OpenAiModerationModelsJsonRPCService;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.ArrayList;
import java.util.List;

public class OpenAiDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem cardPage(LangChain4jOpenAiBuildConfig config, List<SelectedImageModelProviderBuildItem> imageModels, List<SelectedModerationModelProviderBuildItem> moderationModels) {
        CardPageBuildItem card = new CardPageBuildItem();
        this.addImageModelPage(config, card, imageModels);
        this.addModerationModelPage(config, card, moderationModels);
        return card;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void jsonRpcProviders(BuildProducer<JsonRPCProvidersBuildItem> rpcProviders, LangChain4jOpenAiBuildConfig config) {
        if (config.imageModel().enabled().orElse(true).booleanValue()) {
            rpcProviders.produce((BuildItem)new JsonRPCProvidersBuildItem(OpenAiImagesJsonRPCService.class));
        }
        if (config.moderationModel().enabled().orElse(true).booleanValue()) {
            rpcProviders.produce((BuildItem)new JsonRPCProvidersBuildItem(OpenAiModerationModelsJsonRPCService.class));
        }
    }

    private void addImageModelPage(LangChain4jOpenAiBuildConfig config, CardPageBuildItem card, List<SelectedImageModelProviderBuildItem> imageModels) {
        ArrayList<String> configurations = new ArrayList<String>();
        for (SelectedImageModelProviderBuildItem imageModel : imageModels) {
            configurations.add(imageModel.getModelName());
        }
        if (configurations.isEmpty()) {
            configurations.add("<default>");
        }
        if (config.imageModel().enabled().orElse(true).booleanValue()) {
            card.addBuildTimeData("imageModelConfigurations", configurations);
            card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Images")).componentLink("qwc-images.js").icon("font-awesome-solid:palette"));
        }
    }

    private void addModerationModelPage(LangChain4jOpenAiBuildConfig config, CardPageBuildItem card, List<SelectedModerationModelProviderBuildItem> moderationModels) {
        ArrayList<String> configurations = new ArrayList<String>();
        for (SelectedModerationModelProviderBuildItem imageModel : moderationModels) {
            configurations.add(imageModel.getModelName());
        }
        if (configurations.isEmpty()) {
            configurations.add("<default>");
        }
        if (config.moderationModel().enabled().orElse(true).booleanValue()) {
            card.addBuildTimeData("moderationModelConfigurations", configurations);
            card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Moderation model")).componentLink("qwc-moderation.js").icon("font-awesome-solid:triangle-exclamation"));
        }
    }
}

