/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.ollama.CompletionRequest;
import io.quarkiverse.langchain4j.ollama.CompletionResponse;
import io.quarkiverse.langchain4j.ollama.OllamaClient;
import io.quarkiverse.langchain4j.ollama.Options;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class OllamaChatLanguageModel
implements ChatLanguageModel {
    private final OllamaClient client;
    private final String model;
    private final Options options;

    private OllamaChatLanguageModel(Builder builder) {
        this.client = new OllamaClient(builder.baseUrl, builder.timeout, builder.logRequests, builder.logResponses);
        this.model = builder.model;
        this.options = builder.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        CompletionRequest request = CompletionRequest.builder().prompt(messages.stream().map(ChatMessage::text).collect(Collectors.joining("\n"))).model(this.model).options(this.options).build();
        CompletionResponse response = this.client.completion(request);
        return Response.from((Object)AiMessage.from((String)response.getResponse()));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        throw new IllegalArgumentException("Tools are currently not supported for Ollama models");
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        throw new IllegalArgumentException("Tools are currently not supported for Ollama models");
    }

    public static final class Builder {
        private String baseUrl = "http://localhost:11434";
        private Duration timeout = Duration.ofSeconds(10L);
        private String model;
        private Options options;
        private boolean logRequests = false;
        private boolean logResponses = false;

        private Builder() {
        }

        public Builder baseUrl(String val) {
            this.baseUrl = val;
            return this;
        }

        public Builder timeout(Duration val) {
            this.timeout = val;
            return this;
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder options(Options val) {
            this.options = val;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaChatLanguageModel build() {
            return new OllamaChatLanguageModel(this);
        }
    }
}

