/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

public class Options {
    private final Double temperature;
    private final Integer numPredict;
    private final String stop;
    private final Double topP;
    private final Integer topK;

    private Options(Builder builder) {
        this.temperature = builder.temperature;
        this.numPredict = builder.numPredict;
        this.stop = builder.stop;
        this.topP = builder.topP;
        this.topK = builder.topK;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getNumPredict() {
        return this.numPredict;
    }

    public String getStop() {
        return this.stop;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public static final class Builder {
        private Double temperature = 0.8;
        private Integer numPredict = 128;
        private String stop;
        private Double topP = 0.9;
        private Integer topK = 40;

        public Builder temperature(Double val) {
            this.temperature = val;
            return this;
        }

        public Builder numPredict(Integer numPredict) {
            this.numPredict = numPredict;
            return this;
        }

        public Builder stop(String stop) {
            this.stop = stop;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

