/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import io.quarkiverse.langchain4j.ollama.ImageUtils;
import io.quarkiverse.langchain4j.ollama.Message;
import io.quarkiverse.langchain4j.ollama.Role;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class MessageMapper {
    private static final Predicate<ChatMessage> isUserMessage = chatMessage -> chatMessage instanceof UserMessage;
    private static final Predicate<UserMessage> hasImages = userMessage -> userMessage.contents().stream().anyMatch(content -> ContentType.IMAGE.equals((Object)content.type()));

    private MessageMapper() {
    }

    static List<Message> toOllamaMessages(List<ChatMessage> messages) {
        return messages.stream().map(message -> isUserMessage.test((ChatMessage)message) && hasImages.test((UserMessage)message) ? MessageMapper.messagesWithImageSupport((UserMessage)message) : MessageMapper.otherMessages(message)).collect(Collectors.toList());
    }

    private static Message messagesWithImageSupport(UserMessage userMessage) {
        Map<ContentType, List<Content>> groupedContents = userMessage.contents().stream().collect(Collectors.groupingBy(Content::type));
        if (groupedContents.get(ContentType.TEXT).size() != 1) {
            throw new RuntimeException("Expecting single text content, but got: " + userMessage.contents());
        }
        String text = ((TextContent)groupedContents.get(ContentType.TEXT).get(0)).text();
        List<ImageContent> imageContents = groupedContents.get(ContentType.IMAGE).stream().map(content -> (ImageContent)content).collect(Collectors.toList());
        return Message.builder().role(MessageMapper.toOllamaRole(userMessage.type())).content(text).images(ImageUtils.base64EncodeImageList(imageContents)).build();
    }

    private static Message otherMessages(ChatMessage chatMessage) {
        return Message.builder().role(MessageMapper.toOllamaRole(chatMessage.type())).content(chatMessage.text()).build();
    }

    private static Role toOllamaRole(ChatMessageType chatMessageType) {
        return switch (chatMessageType) {
            case ChatMessageType.SYSTEM -> Role.SYSTEM;
            case ChatMessageType.USER -> Role.USER;
            case ChatMessageType.AI -> Role.ASSISTANT;
            default -> throw new IllegalArgumentException("Unknown ChatMessageType: " + chatMessageType);
        };
    }
}

