/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama.devservices;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkiverse.langchain4j.ollama.devservices.OllamaConfig;
import io.quarkus.devservices.common.ConfigureUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LazyFuture;

public class OllamaContainer
extends GenericContainer<OllamaContainer> {
    public static final String CONFIG_OLLAMA_PORT = "ollama.ollama.port";
    public static final String CONFIG_OLLAMA_HTTP_SERVER = "ollama.ollama.http.server";
    private static final Logger log = Logger.getLogger(OllamaContainer.class);
    private static final Integer PORT_OLLAMA = 11434;
    private final DockerImageName dockerImageName;
    private final OllamaConfig config;
    private final String localOllamaImage;
    private final boolean useSharedNetwork;
    private String hostName;
    private String runtimeModelId;

    OllamaContainer(OllamaConfig config, String localOllamaImage, boolean useSharedNetwork, LazyFuture<DockerImageName> image) {
        super((DockerImageName)image.get());
        this.config = config;
        this.dockerImageName = (DockerImageName)image.get();
        this.localOllamaImage = localOllamaImage;
        this.useSharedNetwork = useSharedNetwork;
        this.runtimeModelId = OllamaContainer.getModelId(config);
        super.withLabel("quarkus-dev-service-ollama", "ollama");
        super.withNetwork(Network.SHARED);
        super.addFixedExposedPort(PORT_OLLAMA.intValue(), PORT_OLLAMA.intValue());
        super.withImagePullPolicy(dockerImageName -> !dockerImageName.getVersionPart().endsWith(this.runtimeModelId));
    }

    protected void configure() {
        super.configure();
        if (this.useSharedNetwork) {
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"ollama");
        }
    }

    public Map<String, String> getExposedConfig() {
        HashMap<String, String> exposed = new HashMap<String, String>(2);
        exposed.put(CONFIG_OLLAMA_PORT, Objects.toString(PORT_OLLAMA));
        exposed.put(CONFIG_OLLAMA_HTTP_SERVER, this.getOllamaHost());
        exposed.putAll(super.getEnvMap());
        return exposed;
    }

    public String getOllamaHost() {
        if (this.hostName != null && !this.hostName.isEmpty()) {
            return this.hostName;
        }
        return this.getHost();
    }

    static String getModelId(OllamaConfig config) {
        String modelId = ConfigProvider.getConfig().getOptionalValue("quarkus.langchain4j.ollama.chat-model.model-id", String.class).orElse("");
        if ("".equals(modelId)) {
            String key;
            Iterator iterator = ConfigProvider.getConfig().getPropertyNames().iterator();
            while (iterator.hasNext() && (!(key = (String)iterator.next()).contains("quarkus.langchain4j.ollama.chat-model.") || !key.endsWith("model-id") || "".equals(modelId = ConfigProvider.getConfig().getOptionalValue(key, String.class).orElse("")))) {
            }
        }
        if ("".equals(modelId)) {
            return config.model();
        }
        return modelId;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (!this.dockerImageName.equals((Object)DockerImageName.parse((String)this.localOllamaImage))) {
            try {
                log.infof("Pulling the '%s' model . This could take several minutes", (Object)this.runtimeModelId);
                this.execInContainer(new String[]{"ollama", "pull", this.runtimeModelId});
                log.info((Object)"Pull competed!");
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Error pulling orca-mini model", e);
            }
        }
    }
}

