/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mistralai;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.mistralai.DefaultMistralAiHelper;
import dev.langchain4j.model.mistralai.MistralAiChatCompletionChoice;
import dev.langchain4j.model.mistralai.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.MistralAiClient;
import dev.langchain4j.model.mistralai.MistralAiClientBuilderFactory;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingResponse;
import dev.langchain4j.model.mistralai.MistralAiModelResponse;
import dev.langchain4j.model.mistralai.MistralAiUsage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.mistralai.MistralAiRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusMistralAiClient
extends MistralAiClient {
    private final String apiKey;
    private final MistralAiRestApi restApi;

    public QuarkusMistralAiClient(Builder builder) {
        this.apiKey = builder.apiKey;
        try {
            QuarkusRestClientBuilder restApiBuilder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(builder.baseUrl)).connectTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS);
            if (builder.logRequests.booleanValue() || builder.logResponses.booleanValue()) {
                restApiBuilder.loggingScope(LoggingScope.REQUEST_RESPONSE);
                restApiBuilder.clientLogger((ClientLogger)new MistralAiClientLogger(builder.logRequests, builder.logResponses));
            }
            this.restApi = (MistralAiRestApi)restApiBuilder.build(MistralAiRestApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public MistralAiChatCompletionResponse chatCompletion(MistralAiChatCompletionRequest request) {
        return this.restApi.blockingChatCompletion(request, this.apiKey);
    }

    public void streamingChatCompletion(MistralAiChatCompletionRequest request, final StreamingResponseHandler<AiMessage> handler) {
        final AtomicReference<StringBuffer> contentBuilder = new AtomicReference<StringBuffer>(new StringBuffer());
        final AtomicReference tokenUsage = new AtomicReference();
        final AtomicReference finishReason = new AtomicReference();
        this.restApi.streamingChatCompletion(request, this.apiKey).subscribe().with((Consumer)new Consumer<MistralAiChatCompletionResponse>(){

            @Override
            public void accept(MistralAiChatCompletionResponse response) {
                String finishReasonString;
                MistralAiUsage usageInfo;
                MistralAiChatCompletionChoice choice = (MistralAiChatCompletionChoice)response.getChoices().get(0);
                String chunk = choice.getDelta().getContent();
                ((StringBuffer)contentBuilder.get()).append(chunk);
                if (chunk != null) {
                    handler.onNext(chunk);
                }
                if ((usageInfo = response.getUsage()) != null) {
                    tokenUsage.set(DefaultMistralAiHelper.tokenUsageFrom((MistralAiUsage)usageInfo));
                }
                if ((finishReasonString = choice.getFinishReason()) != null) {
                    finishReason.set(DefaultMistralAiHelper.finishReasonFrom((String)finishReasonString));
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                handler.onError(t);
            }
        }, new Runnable(){

            @Override
            public void run() {
                Response response = Response.from((Object)AiMessage.from((String)((StringBuffer)contentBuilder.get()).toString()), (TokenUsage)((TokenUsage)tokenUsage.get()), (FinishReason)((FinishReason)finishReason.get()));
                handler.onComplete(response);
            }
        });
    }

    public MistralAiEmbeddingResponse embedding(MistralAiEmbeddingRequest request) {
        return this.restApi.embedding(request, this.apiKey);
    }

    public MistralAiModelResponse listModels() {
        return this.restApi.models(this.apiKey);
    }

    public static class Builder
    extends MistralAiClient.Builder<QuarkusMistralAiClient, Builder> {
        public QuarkusMistralAiClient build() {
            return new QuarkusMistralAiClient(this);
        }
    }

    static class MistralAiClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(MistralAiClientLogger.class);
        private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*)(\\w{2})(\\w+)(\\w{2})");
        private final boolean logRequests;
        private final boolean logResponses;

        public MistralAiClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (!this.logRequests || !log.isInfoEnabled()) {
                return;
            }
            try {
                log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
            }
            catch (Exception e) {
                log.warn((Object)"Failed to log request", (Throwable)e);
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (!this.logResponses || !log.isInfoEnabled()) {
                return;
            }
            response.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    try {
                        log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Failed to log response", (Throwable)e);
                    }
                }
            });
        }

        private String bodyToString(Buffer body) {
            if (body == null) {
                return "";
            }
            return body.toString();
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("Authorization")) {
                    headerValue = MistralAiClientLogger.maskAuthorizationHeaderValue(headerValue);
                }
                return String.format("[%s: %s]", headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
            try {
                Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
                StringBuilder sb = new StringBuilder();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    public static class QuarkusMistralAiClientBuilderFactory
    implements MistralAiClientBuilderFactory {
        public Builder get() {
            return new Builder();
        }
    }
}

