/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.mistralai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingChatModel;
import io.quarkiverse.langchain4j.mistralai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.mistralai.runtime.config.LangChain4jMistralAiConfig;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class MistralAiRecorder {
    private static final String DUMMY_KEY = "dummy";

    public Supplier<ChatLanguageModel> chatModel(LangChain4jMistralAiConfig runtimeConfig, String modelName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, modelName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            String apiKey = mistralAiConfig.apiKey();
            ChatModelConfig chatModelConfig = mistralAiConfig.chatModel();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(modelName));
            }
            final MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().baseUrl(mistralAiConfig.baseUrl()).apiKey(apiKey).modelName(chatModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout());
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(Double.valueOf(chatModelConfig.temperature().getAsDouble()));
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(Double.valueOf(chatModelConfig.topP().getAsDouble()));
            }
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(Integer.valueOf(chatModelConfig.maxTokens().getAsInt()));
            }
            if (chatModelConfig.safePrompt().isPresent()) {
                builder.safePrompt(chatModelConfig.safePrompt().get());
            }
            if (chatModelConfig.randomSeed().isPresent()) {
                builder.randomSeed(Integer.valueOf(chatModelConfig.randomSeed().getAsInt()));
            }
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(LangChain4jMistralAiConfig runtimeConfig, String modelName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, modelName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            String apiKey = mistralAiConfig.apiKey();
            ChatModelConfig chatModelConfig = mistralAiConfig.chatModel();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(modelName));
            }
            final MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder builder = MistralAiStreamingChatModel.builder().baseUrl(mistralAiConfig.baseUrl()).apiKey(apiKey).modelName(chatModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{chatModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout());
            if (chatModelConfig.temperature().isPresent()) {
                builder.temperature(Double.valueOf(chatModelConfig.temperature().getAsDouble()));
            }
            if (chatModelConfig.topP().isPresent()) {
                builder.topP(Double.valueOf(chatModelConfig.topP().getAsDouble()));
            }
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(Integer.valueOf(chatModelConfig.maxTokens().getAsInt()));
            }
            if (chatModelConfig.safePrompt().isPresent()) {
                builder.safePrompt(chatModelConfig.safePrompt().get());
            }
            if (chatModelConfig.randomSeed().isPresent()) {
                builder.randomSeed(Integer.valueOf(chatModelConfig.randomSeed().getAsInt()));
            }
            return new Supplier<StreamingChatLanguageModel>(){

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jMistralAiConfig runtimeConfig, String modelName) {
        LangChain4jMistralAiConfig.MistralAiConfig mistralAiConfig = this.correspondingMistralAiConfig(runtimeConfig, modelName);
        if (mistralAiConfig.enableIntegration().booleanValue()) {
            String apiKey = mistralAiConfig.apiKey();
            EmbeddingModelConfig embeddingModelConfig = mistralAiConfig.embeddingModel();
            if (DUMMY_KEY.equals(apiKey)) {
                throw new ConfigValidationException(this.createApiKeyConfigProblem(modelName));
            }
            final MistralAiEmbeddingModel.MistralAiEmbeddingModelBuilder builder = MistralAiEmbeddingModel.builder().baseUrl(mistralAiConfig.baseUrl()).apiKey(apiKey).modelName(embeddingModelConfig.modelName()).logRequests((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logRequests(), mistralAiConfig.logRequests()})).logResponses((Boolean)OptionalUtil.firstOrDefault((Object)false, (Optional[])new Optional[]{embeddingModelConfig.logResponses(), mistralAiConfig.logResponses()})).timeout(mistralAiConfig.timeout());
            return new Supplier<EmbeddingModel>(){

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    private LangChain4jMistralAiConfig.MistralAiConfig correspondingMistralAiConfig(LangChain4jMistralAiConfig runtimeConfig, String modelName) {
        LangChain4jMistralAiConfig.MistralAiConfig huggingFaceConfig = NamedModelUtil.isDefault((String)modelName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(modelName);
        return huggingFaceConfig;
    }

    private ConfigValidationException.Problem[] createApiKeyConfigProblem(String modelName) {
        return this.createConfigProblems("api-key", modelName);
    }

    private ConfigValidationException.Problem[] createConfigProblems(String key, String modelName) {
        return new ConfigValidationException.Problem[]{MistralAiRecorder.createConfigProblem(key, modelName)};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String modelName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.mistralai%s%s is required but it could not be found in any config source", NamedModelUtil.isDefault((String)modelName) ? "." : "." + modelName + ".", key));
    }
}

