/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.milvus;

import io.quarkiverse.langchain4j.milvus.MilvusBuildConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class MilvusDevServicesProcessor {
    private static final Logger log = Logger.getLogger(MilvusDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-milvus";
    private static final String ETCD_IMAGE_NAME = "docker.io/coreos/etcd";
    private static final String MINIO_IMAGE_NAME = "docker.io/minio/minio";
    private static final String MILVUS_IMAGE_NAME = "docker.io/milvusdb/milvus";
    private static final int MILVUS_PORT = 19530;
    private static final int MINIO_PORT = 9000;
    private static final int ETCD_PORT = 2379;
    private static final ContainerLocator containerLocator = new ContainerLocator("quarkus-dev-service-milvus", 19530);
    static volatile DevServicesResultBuildItem.RunningDevService milvusDevService;
    static volatile DevServicesResultBuildItem.RunningDevService minioDevService;
    static volatile DevServicesResultBuildItem.RunningDevService etcdDevService;
    static volatile MilvusDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public List<DevServicesResultBuildItem> startMilvusDevServices(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, MilvusBuildConfig milvusBuildConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ArrayList<DevServicesResultBuildItem> result = new ArrayList<DevServicesResultBuildItem>();
        MilvusDevServiceCfg configuration = this.getConfiguration(milvusBuildConfig);
        if (milvusDevService != null || etcdDevService != null || minioDevService != null) {
            boolean shouldShutdown;
            boolean bl = shouldShutdown = !configuration.equals(cfg);
            if (!shouldShutdown) {
                result.add(milvusDevService.toBuildItem());
                result.add(etcdDevService.toBuildItem());
                result.add(minioDevService.toBuildItem());
                return result;
            }
            this.shutdownContainers();
            cfg = null;
        }
        if (!milvusBuildConfig.devservices().enabled()) {
            log.debug((Object)"Not starting Dev Services for Milvus, as it has been disabled in the config.");
            return Collections.emptyList();
        }
        if (ConfigUtils.isPropertyPresent((String)"quarkus.langchain4j.milvus.host")) {
            return Collections.emptyList();
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Milvus Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newEtcdDevService = this.startEtcdContainer(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout);
            if (newEtcdDevService != null && (etcdDevService = newEtcdDevService).isOwner()) {
                log.info((Object)"Dev Services instance of Etcd started.");
            }
            if (etcdDevService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
            DevServicesResultBuildItem.RunningDevService newMinioDevService = this.startMinioContainer(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout);
            if (newMinioDevService != null && (minioDevService = newMinioDevService).isOwner()) {
                log.info((Object)"Dev Services instance of Minio started.");
            }
            if (minioDevService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
            DevServicesResultBuildItem.RunningDevService newMilvusDevService = this.startMilvusContainer(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout, (String)newMinioDevService.getConfig().get("minio-host"), (String)newMinioDevService.getConfig().get("minio-port"), (String)newEtcdDevService.getConfig().get("etcd-host"), (String)newEtcdDevService.getConfig().get("etcd-port"));
            if (newMilvusDevService != null && (milvusDevService = newMilvusDevService).isOwner()) {
                log.info((Object)"Dev Services instance of Milvus started.");
            }
            if (milvusDevService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (milvusDevService == null || etcdDevService == null || minioDevService == null) {
            return Collections.emptyList();
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                this.shutdownContainers();
                first = true;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = configuration;
        result.add(milvusDevService.toBuildItem());
        result.add(etcdDevService.toBuildItem());
        result.add(minioDevService.toBuildItem());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownContainers() {
        if (milvusDevService != null) {
            try {
                milvusDevService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Milvus server", e);
            }
            finally {
                milvusDevService = null;
            }
        }
        if (etcdDevService != null) {
            try {
                etcdDevService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Etcd server", e);
            }
            finally {
                etcdDevService = null;
            }
        }
        if (minioDevService != null) {
            try {
                minioDevService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Minio server", e);
            }
            finally {
                minioDevService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startMilvusContainer(DockerStatusBuildItem dockerStatusBuildItem, MilvusDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout, String minioHost, String minioPort, String etcdHost, String etcdPort) {
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the Milvus server location.");
            return null;
        }
        ConfiguredMilvusContainer container = new ConfiguredMilvusContainer(DockerImageName.parse((String)config.milvusImageName).asCompatibleSubstituteFor(MILVUS_IMAGE_NAME), config.fixedMilvusPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMilvusSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((ConfiguredMilvusContainer)container).withStartupTimeout(arg_0));
            container.addEnv("ETCD_ENDPOINTS", etcdHost + ":" + etcdPort);
            container.addEnv("MINIO_ADDRESS", minioHost + ":" + minioPort);
            container.start();
            return this.getRunningMilvusDevService(container.getContainerId(), () -> ((ConfiguredMilvusContainer)container).close(), container.getHost(), container.getPort());
        };
        return containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningMilvusDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultMilvusSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService startMinioContainer(DockerStatusBuildItem dockerStatusBuildItem, MilvusDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        ConfiguredMinioContainer container = new ConfiguredMinioContainer(DockerImageName.parse((String)config.minioImageName).asCompatibleSubstituteFor(MINIO_IMAGE_NAME), launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMinioSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((ConfiguredMinioContainer)container).withStartupTimeout(arg_0));
            container.start();
            return this.getRunningMinioDevService(container.getContainerId(), () -> ((ConfiguredMinioContainer)container).close(), container.getHost(), container.getPort());
        };
        return containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningMinioDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultMinioSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService startEtcdContainer(DockerStatusBuildItem dockerStatusBuildItem, MilvusDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        ConfiguredEtcdContainer container = new ConfiguredEtcdContainer(DockerImageName.parse((String)config.etcdImageName).asCompatibleSubstituteFor(ETCD_IMAGE_NAME), launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultEtcdSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((ConfiguredEtcdContainer)container).withStartupTimeout(arg_0));
            container.addEnv("ETCD_AUTO_COMPACTION_MODE", "revision");
            container.addEnv("ETCD_AUTO_COMPACTION_RETENTION", "1000");
            container.addEnv("ETCD_QUOTA_BACKEND_BYTES", "4294967296");
            container.addEnv("ETCD_SNAPSHOT_COUNT", "50000");
            container.setCommand(new String[]{"etcd", "-advertise-client-urls=http://127.0.0.1:2379", "-listen-client-urls=http://0.0.0.0:2379", "--data-dir=/etcd"});
            container.start();
            return this.getRunningEtcdDevService(container.getContainerId(), () -> ((ConfiguredEtcdContainer)container).close(), container.getHost(), container.getPort());
        };
        return containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningEtcdDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultEtcdSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningMilvusDevService(String containerId, Closeable closeable, String host, int port) {
        Map<String, String> configMap = Map.of("quarkus.langchain4j.milvus.host", "localhost", "quarkus.langchain4j.milvus.port", String.valueOf(port));
        return new DevServicesResultBuildItem.RunningDevService("langchain4j-milvus", containerId, closeable, configMap);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningMinioDevService(String containerId, Closeable closeable, String host, int port) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("minio-host", host);
        configMap.put("minio-port", String.valueOf(port));
        return new DevServicesResultBuildItem.RunningDevService("langchain4j-milvus", containerId, closeable, configMap);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningEtcdDevService(String containerId, Closeable closeable, String host, int port) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("etcd-host", host);
        configMap.put("etcd-port", String.valueOf(port));
        return new DevServicesResultBuildItem.RunningDevService("langchain4j-milvus", containerId, closeable, configMap);
    }

    private MilvusDevServiceCfg getConfiguration(MilvusBuildConfig cfg) {
        return new MilvusDevServiceCfg(cfg.devservices());
    }

    static {
        first = true;
    }

    private static final class MilvusDevServiceCfg {
        public OptionalInt fixedEtcdPort;
        private boolean devServicesEnabled;
        private OptionalInt fixedMilvusPort;
        private String milvusImageName;
        private String etcdImageName;
        private String minioImageName;
        private String serviceName;
        private boolean shared;

        public MilvusDevServiceCfg(MilvusBuildConfig.MilvusDevServicesBuildTimeConfig devservices) {
            this.devServicesEnabled = devservices.enabled();
            this.fixedMilvusPort = devservices.port();
            this.milvusImageName = devservices.milvusImageName();
            this.etcdImageName = devservices.etcdImageName();
            this.minioImageName = devservices.minioImageName();
            this.serviceName = devservices.serviceName();
            this.shared = devservices.shared();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MilvusDevServiceCfg that = (MilvusDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && this.shared == that.shared && Objects.equals(this.fixedMilvusPort, that.fixedMilvusPort) && Objects.equals(this.milvusImageName, that.milvusImageName) && Objects.equals(this.etcdImageName, that.etcdImageName) && Objects.equals(this.minioImageName, that.minioImageName) && Objects.equals(this.serviceName, that.serviceName);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.fixedMilvusPort, this.milvusImageName, this.etcdImageName, this.minioImageName, this.serviceName, this.shared);
        }
    }

    private static class ConfiguredMilvusContainer
    extends GenericContainer<ConfiguredMilvusContainer> {
        private final OptionalInt fixedExposedPort;
        private String hostName = null;

        public ConfiguredMilvusContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            if (serviceName != null) {
                this.withLabel(MilvusDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            this.setCommand(new String[]{"milvus", "run", "standalone"});
            this.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*QueryNode successfully started.*\\s"));
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"milvus");
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 19530);
            } else {
                this.addExposedPort(19530);
            }
        }

        public int getPort() {
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getMappedPort(19530);
        }

        public String getHost() {
            return this.hostName;
        }
    }

    private static class ConfiguredMinioContainer
    extends GenericContainer<ConfiguredMinioContainer> {
        private String hostName = null;

        public ConfiguredMinioContainer(DockerImageName dockerImageName, String serviceName) {
            super(dockerImageName);
            if (serviceName != null) {
                this.withLabel(MilvusDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            this.setCommand(new String[]{"server", "--console-address", ":9001", "/data"});
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"minio");
        }

        public int getPort() {
            return 9000;
        }

        public String getHost() {
            return this.hostName;
        }
    }

    private static class ConfiguredEtcdContainer
    extends GenericContainer<ConfiguredEtcdContainer> {
        private String hostName = null;

        public ConfiguredEtcdContainer(DockerImageName dockerImageName, String serviceName) {
            super(dockerImageName);
            if (serviceName != null) {
                this.withLabel(MilvusDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"etcd");
        }

        public int getPort() {
            return 2379;
        }

        public String getHost() {
            return this.hostName;
        }
    }
}

