/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.milvus;

import io.quarkiverse.langchain4j.milvus.MilvusBuildConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.milvus.MilvusContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class MilvusDevServicesProcessor {
    private static final Logger log = Logger.getLogger(MilvusDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-milvus";
    private static final String MILVUS_IMAGE_NAME = "docker.io/milvusdb/milvus";
    private static final int MILVUS_PORT = 19530;
    private static final ContainerLocator containerLocator = new ContainerLocator("quarkus-dev-service-milvus", 19530);
    static volatile DevServicesResultBuildItem.RunningDevService milvusDevService;
    static volatile MilvusDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public List<DevServicesResultBuildItem> startMilvusDevServices(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, MilvusBuildConfig milvusBuildConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ArrayList<DevServicesResultBuildItem> result = new ArrayList<DevServicesResultBuildItem>();
        MilvusDevServiceCfg configuration = this.getConfiguration(milvusBuildConfig);
        if (milvusDevService != null) {
            boolean shouldShutdown;
            boolean bl = shouldShutdown = !configuration.equals(cfg);
            if (!shouldShutdown) {
                result.add(milvusDevService.toBuildItem());
                return result;
            }
            this.shutdownContainers();
            cfg = null;
        }
        if (!milvusBuildConfig.devservices().enabled()) {
            log.debug((Object)"Not starting Dev Services for Milvus, as it has been disabled in the config.");
            return Collections.emptyList();
        }
        if (ConfigUtils.isPropertyPresent((String)"quarkus.langchain4j.milvus.host")) {
            return Collections.emptyList();
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Milvus Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newMilvusDevService = this.startMilvusContainer(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout, !devServicesSharedNetworkBuildItem.isEmpty());
            if (newMilvusDevService != null && (milvusDevService = newMilvusDevService).isOwner()) {
                log.info((Object)"Dev Services instance of Milvus started.");
            }
            if (milvusDevService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (milvusDevService == null) {
            return Collections.emptyList();
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                this.shutdownContainers();
                first = true;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = configuration;
        result.add(milvusDevService.toBuildItem());
        return result;
    }

    private void shutdownContainers() {
        if (milvusDevService != null) {
            try {
                milvusDevService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Milvus server", e);
            }
            finally {
                milvusDevService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startMilvusContainer(DockerStatusBuildItem dockerStatusBuildItem, MilvusDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout, boolean useSharedNetwork) {
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the Milvus server location.");
            return null;
        }
        QuarkusMilvusContainer container = new QuarkusMilvusContainer(config.milvusImageName, config.fixedMilvusPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMilvusSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((QuarkusMilvusContainer)container).withStartupTimeout(arg_0));
            container.start();
            return this.getRunningMilvusDevService(container.getContainerId(), () -> ((QuarkusMilvusContainer)container).close(), container.getHost(), container.getPort());
        };
        return containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningMilvusDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultMilvusSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningMilvusDevService(String containerId, Closeable closeable, String host, int port) {
        Map<String, String> configMap = Map.of("quarkus.langchain4j.milvus.host", host, "quarkus.langchain4j.milvus.port", String.valueOf(port));
        return new DevServicesResultBuildItem.RunningDevService("langchain4j-milvus", containerId, closeable, configMap);
    }

    private MilvusDevServiceCfg getConfiguration(MilvusBuildConfig cfg) {
        return new MilvusDevServiceCfg(cfg.devservices());
    }

    static {
        first = true;
    }

    private static final class MilvusDevServiceCfg {
        private boolean devServicesEnabled;
        private OptionalInt fixedMilvusPort;
        private String milvusImageName;
        private String serviceName;
        private boolean shared;

        public MilvusDevServiceCfg(MilvusBuildConfig.MilvusDevServicesBuildTimeConfig devservices) {
            this.devServicesEnabled = devservices.enabled();
            this.fixedMilvusPort = devservices.port();
            this.milvusImageName = devservices.milvusImageName();
            this.serviceName = devservices.serviceName();
            this.shared = devservices.shared();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MilvusDevServiceCfg that = (MilvusDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && this.shared == that.shared && Objects.equals(this.fixedMilvusPort, that.fixedMilvusPort) && Objects.equals(this.milvusImageName, that.milvusImageName) && Objects.equals(this.serviceName, that.serviceName);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.fixedMilvusPort, this.milvusImageName, this.serviceName, this.shared);
        }
    }

    static class QuarkusMilvusContainer
    extends MilvusContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMilvusContainer(String image, OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)image).asCompatibleSubstituteFor("milvusdb/milvus"));
            if (serviceName != null) {
                this.withLabel(MilvusDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"milvus");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 19530);
            } else {
                this.addExposedPort(19530);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 19530;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getMappedPort(19530);
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

