/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.memorystore;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.quarkus.redis.datasource.value.ValueCommands;
import java.util.Collections;
import java.util.List;

public class RedisChatMemoryStore
implements ChatMemoryStore {
    private final ValueCommands<String, List<ChatMessage>> valueCommands;
    private final KeyCommands<String> keyCommands;

    public RedisChatMemoryStore(RedisDataSource redisDataSource) {
        this.valueCommands = redisDataSource.value((TypeReference)new TypeReference<List<ChatMessage>>(){});
        this.keyCommands = redisDataSource.key(String.class);
    }

    public void deleteMessages(Object memoryId) {
        this.keyCommands.del((Object[])new String[]{memoryId.toString()});
    }

    public List<ChatMessage> getMessages(Object memoryId) {
        List chatMessages = (List)this.valueCommands.get((Object)memoryId.toString());
        if (chatMessages != null) {
            return chatMessages;
        }
        return Collections.emptyList();
    }

    public void updateMessages(Object memoryId, List<ChatMessage> messages) {
        this.valueCommands.set((Object)memoryId.toString(), messages);
    }
}

