/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.infinispan;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.quarkiverse.langchain4j.deployment.EmbeddingStoreBuildItem;
import io.quarkiverse.langchain4j.infinispan.InfinispanEmbeddingStore;
import io.quarkiverse.langchain4j.infinispan.InfinispanEmbeddingStoreBuildTimeConfig;
import io.quarkiverse.langchain4j.infinispan.SchemaAndMarshallerProducer;
import io.quarkiverse.langchain4j.infinispan.runtime.InfinispanEmbeddingStoreConfig;
import io.quarkiverse.langchain4j.infinispan.runtime.InfinispanEmbeddingStoreRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.infinispan.client.InfinispanClientName;
import io.quarkus.infinispan.client.deployment.InfinispanClientNameBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class InfinispanEmbeddingStoreProcessor {
    public static final DotName INFINISPAN_EMBEDDING_STORE = DotName.createSimple(InfinispanEmbeddingStore.class);
    private static final String FEATURE = "langchain4j-infinispan";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public InfinispanClientNameBuildItem requestInfinispanClient(BuildProducer<AdditionalBeanBuildItem> additionalBeans, InfinispanEmbeddingStoreBuildTimeConfig config) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SchemaAndMarshallerProducer.class));
        return new InfinispanClientNameBuildItem(config.clientName().orElse("<default>"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void createBean(BuildProducer<SyntheticBeanBuildItem> beanProducer, InfinispanEmbeddingStoreRecorder recorder, InfinispanEmbeddingStoreConfig config, BuildProducer<EmbeddingStoreBuildItem> embeddingStoreProducer, InfinispanEmbeddingStoreBuildTimeConfig buildTimeConfig) {
        String clientName = buildTimeConfig.clientName().orElse(null);
        AnnotationInstance infinispanClientQualifier = clientName == null ? AnnotationInstance.builder(Default.class).build() : AnnotationInstance.builder(InfinispanClientName.class).add("value", clientName).build();
        beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)INFINISPAN_EMBEDDING_STORE).types(new Type[]{ClassType.create(EmbeddingStore.class), ParameterizedType.create(EmbeddingStore.class, (Type[])new Type[]{ClassType.create(TextSegment.class)})})).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(RemoteCacheManager.class)), new AnnotationInstance[]{infinispanClientQualifier})).createWith(recorder.embeddingStoreFunction(config, clientName)).done());
        embeddingStoreProducer.produce((BuildItem)new EmbeddingStoreBuildItem());
    }
}

