/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.huggingface;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.huggingface.client.EmbeddingRequest;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.spi.HuggingFaceClientFactory;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.huggingface.QuarkusHuggingFaceClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class QuarkusHuggingFaceEmbeddingModel
implements EmbeddingModel {
    public static final QuarkusHuggingFaceClientFactory CLIENT_FACTORY = new QuarkusHuggingFaceClientFactory();
    private final HuggingFaceClient client;
    private final boolean waitForModel;

    private QuarkusHuggingFaceEmbeddingModel(final Builder builder) {
        this.client = CLIENT_FACTORY.create(null, new HuggingFaceClientFactory.Input(){

            public String apiKey() {
                return builder.accessToken;
            }

            public String modelId() {
                throw new UnsupportedOperationException("Should not be called");
            }

            public Duration timeout() {
                return builder.timeout;
            }
        }, builder.url);
        this.waitForModel = builder.waitForModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        EmbeddingRequest request = new EmbeddingRequest(texts, this.waitForModel);
        List response = this.client.embed(request);
        List embeddings = response.stream().map(Embedding::from).collect(Collectors.toList());
        return Response.from(embeddings);
    }

    public static final class Builder {
        private String accessToken;
        private Duration timeout = Duration.ofSeconds(15L);
        private Boolean waitForModel = true;
        private URI url = URI.create("https://api-inference.huggingface.co/pipeline/feature-extraction/sentence-transformers/all-MiniLM-L6-v2");

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder url(URL url) {
            try {
                this.url = url.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder waitForModel(Boolean waitForModel) {
            this.waitForModel = waitForModel;
            return this;
        }

        public QuarkusHuggingFaceEmbeddingModel build() {
            return new QuarkusHuggingFaceEmbeddingModel(this);
        }
    }
}

