/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.easyrag.runtime;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.loader.FileSystemDocumentLoader;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.HuggingFaceTokenizer;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRagConfig;
import io.quarkiverse.langchain4j.easyrag.runtime.EasyRetrievalAugmentor;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class EasyRagRecorder {
    private static final Logger LOGGER = Logger.getLogger(EasyRagRecorder.class);

    public void ingest(EasyRagConfig config, BeanContainer beanContainer) {
        EmbeddingStore embeddingStore = (EmbeddingStore)beanContainer.beanInstance(EmbeddingStore.class, new Annotation[0]);
        EmbeddingModel embeddingModel = (EmbeddingModel)beanContainer.beanInstance(EmbeddingModel.class, new Annotation[0]);
        LOGGER.info((Object)("Ingesting documents from path: " + config.path()));
        List documents = FileSystemDocumentLoader.loadDocuments((String)config.path());
        DocumentSplitter documentSplitter = DocumentSplitters.recursive((int)config.maxSegmentSize(), (int)config.maxOverlapSize(), (Tokenizer)new HuggingFaceTokenizer());
        List<Document> splitDocuments = documentSplitter.splitAll(documents).stream().map(split -> new Document(split.text())).toList();
        EmbeddingStoreIngestor.builder().embeddingModel(embeddingModel).embeddingStore(embeddingStore).build().ingest(splitDocuments);
        LOGGER.info((Object)("Ingested " + documents.size() + " files as " + splitDocuments.size() + " documents"));
    }

    public Supplier<InMemoryEmbeddingStore> inMemoryEmbeddingStoreSupplier() {
        return new Supplier<InMemoryEmbeddingStore>(){

            @Override
            public InMemoryEmbeddingStore get() {
                return new InMemoryEmbeddingStore();
            }
        };
    }

    public Function<SyntheticCreationalContext<RetrievalAugmentor>, RetrievalAugmentor> easyRetrievalAugmentorFunction(final EasyRagConfig config) {
        return new Function<SyntheticCreationalContext<RetrievalAugmentor>, RetrievalAugmentor>(){

            @Override
            public RetrievalAugmentor apply(SyntheticCreationalContext<RetrievalAugmentor> context) {
                EmbeddingModel model = (EmbeddingModel)context.getInjectedReference(EmbeddingModel.class, new Annotation[]{new Default.Literal()});
                EmbeddingStore store = (EmbeddingStore)context.getInjectedReference(EmbeddingStore.class, new Annotation[]{new Default.Literal()});
                return new EasyRetrievalAugmentor(config.maxResults(), model, store);
            }
        };
    }
}

