/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.devui.json;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import io.quarkiverse.langchain4j.runtime.devui.json.MessageType;
import java.util.List;
import java.util.stream.Collectors;

public class ChatMessagePojo {
    private MessageType type;
    private String message;

    public MessageType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public static List<ChatMessagePojo> listFromMemory(ChatMemory memory) {
        return memory.messages().stream().map(ChatMessagePojo::fromMessage).collect(Collectors.toList());
    }

    public static ChatMessagePojo fromMessage(ChatMessage message) {
        ChatMessagePojo json = new ChatMessagePojo();
        switch (message.type()) {
            case SYSTEM: {
                json.type = MessageType.SYSTEM;
                json.message = ((SystemMessage)message).text();
                break;
            }
            case USER: {
                json.type = MessageType.USER;
                json.message = ((UserMessage)message).text();
                break;
            }
            case AI: {
                json.type = MessageType.AI;
                json.message = ((AiMessage)message).text();
            }
        }
        return json;
    }
}

