/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.devui;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.runtime.devui.json.ChatMessagePojo;
import io.quarkiverse.langchain4j.runtime.devui.json.ChatResultPojo;
import io.quarkus.arc.All;
import io.quarkus.logging.Log;
import jakarta.enterprise.context.control.ActivateRequestContext;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;

@ActivateRequestContext
public class ChatJsonRPCService {
    private final ChatLanguageModel model;
    private final ChatMemoryProvider memoryProvider;
    private final AtomicReference<ChatMemory> currentMemory = new AtomicReference();

    public ChatJsonRPCService(@All List<ChatLanguageModel> models, ChatMemoryProvider memoryProvider) {
        this.model = models.get(0);
        this.memoryProvider = memoryProvider;
    }

    public String reset(String systemMessage) {
        if (this.currentMemory.get() != null) {
            this.currentMemory.get().clear();
        }
        ChatMemory memory = this.memoryProvider.get((Object)ThreadLocalRandom.current().nextLong());
        this.currentMemory.set(memory);
        if (systemMessage != null && !systemMessage.isEmpty()) {
            memory.add((ChatMessage)new SystemMessage(systemMessage));
        }
        return "OK";
    }

    public ChatResultPojo newConversation(String systemMessage, String message) {
        this.reset(systemMessage);
        return this.chat(message);
    }

    public ChatResultPojo chat(String message) {
        ChatMemory memory = this.currentMemory.get();
        List chatMemoryBackup = memory.messages();
        try {
            memory.add((ChatMessage)new UserMessage(message));
            Response modelResponse = this.model.generate(memory.messages());
            memory.add((ChatMessage)modelResponse.content());
            List<ChatMessagePojo> response = ChatMessagePojo.listFromMemory(memory);
            Collections.reverse(response);
            return new ChatResultPojo(response, null);
        }
        catch (Throwable t) {
            memory.clear();
            chatMemoryBackup.forEach(arg_0 -> ((ChatMemory)memory).add(arg_0));
            Log.warn((Object)t);
            return new ChatResultPojo(null, t.getMessage());
        }
    }
}

