/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.quarkiverse.langchain4j.runtime.tool.QuarkusToolExecutor;
import jakarta.inject.Inject;
import java.util.function.BiFunction;

public class ToolSpanWrapper
implements QuarkusToolExecutor.Wrapper {
    private static final String INSTRUMENTATION_NAME = "io.quarkus.opentelemetry";
    private final Instrumenter<ToolExecutionRequest, Void> instrumenter;

    @Inject
    public ToolSpanWrapper(OpenTelemetry openTelemetry) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)InputSpanNameExtractor.INSTANCE);
        this.instrumenter = builder.buildInstrumenter((SpanKindExtractor)new SpanKindExtractor<ToolExecutionRequest>(){

            public SpanKind extract(ToolExecutionRequest toolExecutionRequest) {
                return SpanKind.INTERNAL;
            }
        });
    }

    @Override
    public String wrap(ToolExecutionRequest toolExecutionRequest, Object memoryId, BiFunction<ToolExecutionRequest, Object, String> fun) {
        Context parentContext = Context.current();
        Context spanContext = null;
        Scope scope = null;
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)toolExecutionRequest);
        if (shouldStart) {
            spanContext = this.instrumenter.start(parentContext, (Object)toolExecutionRequest);
            scope = spanContext.makeCurrent();
        }
        try {
            String result = fun.apply(toolExecutionRequest, memoryId);
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)toolExecutionRequest, null, null);
            }
            String string = result;
            return string;
        }
        catch (Throwable t) {
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)toolExecutionRequest, null, t);
            }
            throw t;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    private static class InputSpanNameExtractor
    implements SpanNameExtractor<ToolExecutionRequest> {
        private static final InputSpanNameExtractor INSTANCE = new InputSpanNameExtractor();

        private InputSpanNameExtractor() {
        }

        public String extract(ToolExecutionRequest toolExecutionRequest) {
            return "langchain4j.tools." + toolExecutionRequest.name();
        }
    }
}

