/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.devui;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;

@ActivateRequestContext
public class ChatJsonRPCService {
    @Inject
    ChatLanguageModel model;
    @Inject
    ChatMemoryProvider memoryProvider;
    private AtomicReference<ChatMemory> currentMemory = new AtomicReference();

    public String reset(String systemMessage) {
        if (this.currentMemory.get() != null) {
            this.currentMemory.get().clear();
        }
        ChatMemory memory = this.memoryProvider.get((Object)ThreadLocalRandom.current().nextLong());
        this.currentMemory.set(memory);
        if (systemMessage != null && !systemMessage.isEmpty()) {
            memory.add((ChatMessage)new SystemMessage(systemMessage));
        }
        return "OK";
    }

    public String newConversation(String systemMessage, String message) {
        this.reset(systemMessage);
        return this.chat(message);
    }

    public String chat(String message) {
        ChatMemory memory = this.currentMemory.get();
        memory.add((ChatMessage)new UserMessage(message));
        Response response = this.model.generate(memory.messages());
        memory.add((ChatMessage)response.content());
        return ((AiMessage)response.content()).text();
    }
}

