/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.spi.services.AiServicesFactory;
import io.quarkiverse.langchain4j.audit.AuditService;
import io.quarkiverse.langchain4j.runtime.AiServicesRecorder;
import io.quarkiverse.langchain4j.runtime.ToolsRecorder;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkiverse.langchain4j.runtime.tool.QuarkusToolExecutor;
import io.quarkiverse.langchain4j.runtime.tool.QuarkusToolExecutorFactory;
import io.quarkiverse.langchain4j.runtime.tool.ToolMethodCreateInfo;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class QuarkusAiServicesFactory
implements AiServicesFactory {
    public <T> QuarkusAiServices<T> create(AiServiceContext context) {
        if (context instanceof QuarkusAiServiceContext) {
            return new QuarkusAiServices(context);
        }
        return new QuarkusAiServices(new QuarkusAiServiceContext(context.aiServiceClass));
    }

    public static class QuarkusAiServices<T>
    extends AiServices<T> {
        private static final Logger log = Logger.getLogger(QuarkusAiServices.class);
        private final QuarkusToolExecutorFactory toolExecutorFactory = (QuarkusToolExecutorFactory)Arc.container().instance(QuarkusToolExecutorFactory.class, new Annotation[0]).get();

        public QuarkusAiServices(AiServiceContext context) {
            super(context);
        }

        public AiServices<T> tools(List<Object> objectsWithTools) {
            this.context.toolSpecifications = new ArrayList();
            this.context.toolExecutors = new HashMap();
            for (Object objectWithTool : objectsWithTools) {
                List<ToolMethodCreateInfo> methodCreateInfos = this.lookup(objectWithTool);
                if (!(methodCreateInfos != null && !methodCreateInfos.isEmpty() || methodCreateInfos != null && !methodCreateInfos.isEmpty())) continue;
                for (ToolMethodCreateInfo methodCreateInfo : methodCreateInfos) {
                    String invokerClassName = methodCreateInfo.getInvokerClassName();
                    ToolSpecification toolSpecification = methodCreateInfo.getToolSpecification();
                    this.context.toolSpecifications.add(toolSpecification);
                    QuarkusToolExecutor.Context executorContext = new QuarkusToolExecutor.Context(objectWithTool, invokerClassName, methodCreateInfo.getMethodName(), methodCreateInfo.getArgumentMapperClassName());
                    this.context.toolExecutors.put(toolSpecification.name(), this.toolExecutorFactory.create(executorContext));
                }
            }
            return this;
        }

        public AiServices<T> auditService(AuditService auditService) {
            ((QuarkusAiServiceContext)this.context).auditService = auditService;
            return this;
        }

        List<ToolMethodCreateInfo> lookup(Object obj) {
            String className;
            Map<String, List<ToolMethodCreateInfo>> metadata = ToolsRecorder.getMetadata();
            List<ToolMethodCreateInfo> fast = metadata.get(className = obj.getClass().getName());
            if (fast != null) {
                return fast;
            }
            for (Map.Entry<String, List<ToolMethodCreateInfo>> entry : metadata.entrySet()) {
                String targetClassName = entry.getKey();
                try {
                    Class<?> targetClass = Class.forName(targetClassName, false, Thread.currentThread().getContextClassLoader());
                    if (!targetClass.isAssignableFrom(obj.getClass())) continue;
                    metadata.put(targetClassName, entry.getValue());
                    return entry.getValue();
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Unable to load class " + targetClassName));
                }
            }
            return Collections.emptyList();
        }

        public T build() {
            Class aiServiceClass = this.context.aiServiceClass;
            AiServiceClassCreateInfo classCreateInfo = AiServicesRecorder.getMetadata().get(aiServiceClass.getName());
            if (classCreateInfo == null) {
                throw new RuntimeException("Quarkus was not able to determine class '" + aiServiceClass.getName() + "' as an AiService at build time. Consider annotating the class with '@CreatedAware'");
            }
            this.performBasicValidation();
            Collection<AiServiceMethodCreateInfo> methodCreateInfos = classCreateInfo.getMethodMap().values();
            for (AiServiceMethodCreateInfo methodCreateInfo : methodCreateInfos) {
                if (!methodCreateInfo.isRequiresModeration() || this.context.moderationModel != null) continue;
                throw IllegalConfigurationException.illegalConfiguration((String)"The @Moderate annotation is present, but the moderationModel is not set up. Please ensure a valid moderationModel is configured before using the @Moderate annotation.");
            }
            try {
                return (T)Class.forName(classCreateInfo.getImplClassName(), true, Thread.currentThread().getContextClassLoader()).getConstructor(QuarkusAiServiceContext.class).newInstance(new Object[]{(QuarkusAiServiceContext)this.context});
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create class '" + classCreateInfo.getImplClassName(), e);
            }
        }
    }

    public static class InstanceHolder {
        public static final QuarkusAiServicesFactory INSTANCE = new QuarkusAiServicesFactory();
    }
}

