/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodImplementationSupport;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Function;

public class SpanWrapper
implements AiServiceMethodImplementationSupport.Wrapper {
    private static final String INSTRUMENTATION_NAME = "io.quarkus.opentelemetry";
    private final Instrumenter<AiServiceMethodImplementationSupport.Input, Void> instrumenter;

    @Inject
    public SpanWrapper(OpenTelemetry openTelemetry) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)InputSpanNameExtractor.INSTANCE);
        this.instrumenter = builder.buildInstrumenter((SpanKindExtractor)new SpanKindExtractor<AiServiceMethodImplementationSupport.Input>(){

            public SpanKind extract(AiServiceMethodImplementationSupport.Input input) {
                return SpanKind.INTERNAL;
            }
        });
    }

    @Override
    public Object wrap(AiServiceMethodImplementationSupport.Input input, Function<AiServiceMethodImplementationSupport.Input, Object> fun) {
        Context parentContext = Context.current();
        Context spanContext = null;
        Scope scope = null;
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)input);
        if (shouldStart) {
            spanContext = this.instrumenter.start(parentContext, (Object)input);
            scope = spanContext.makeCurrent();
        }
        try {
            Object result = fun.apply(input);
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)input, null, null);
            }
            Object object = result;
            return object;
        }
        catch (Throwable t) {
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)input, null, t);
            }
            throw t;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    private static class InputSpanNameExtractor
    implements SpanNameExtractor<AiServiceMethodImplementationSupport.Input> {
        private static final InputSpanNameExtractor INSTANCE = new InputSpanNameExtractor();

        private InputSpanNameExtractor() {
        }

        public String extract(AiServiceMethodImplementationSupport.Input input) {
            Optional<AiServiceMethodCreateInfo.SpanInfo> spanInfoOpt = input.createInfo.getSpanInfo();
            if (spanInfoOpt.isPresent()) {
                return spanInfoOpt.get().getName();
            }
            return null;
        }
    }
}

