/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.Map;
import java.util.Optional;

public class AiServiceMethodCreateInfo {
    private final String interfaceName;
    private final String methodName;
    private final Optional<TemplateInfo> systemMessageInfo;
    private final UserMessageInfo userMessageInfo;
    private final Optional<Integer> memoryIdParamPosition;
    private final boolean requiresModeration;
    private final Class<?> returnType;
    private final Optional<MetricsTimedInfo> metricsTimedInfo;
    private final Optional<MetricsCountedInfo> metricsCountedInfo;
    private final Optional<SpanInfo> spanInfo;

    @RecordableConstructor
    public AiServiceMethodCreateInfo(String interfaceName, String methodName, Optional<TemplateInfo> systemMessageInfo, UserMessageInfo userMessageInfo, Optional<Integer> memoryIdParamPosition, boolean requiresModeration, Class<?> returnType, Optional<MetricsTimedInfo> metricsTimedInfo, Optional<MetricsCountedInfo> metricsCountedInfo, Optional<SpanInfo> spanInfo) {
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.systemMessageInfo = systemMessageInfo;
        this.userMessageInfo = userMessageInfo;
        this.memoryIdParamPosition = memoryIdParamPosition;
        this.requiresModeration = requiresModeration;
        this.returnType = returnType;
        this.metricsTimedInfo = metricsTimedInfo;
        this.metricsCountedInfo = metricsCountedInfo;
        this.spanInfo = spanInfo;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Optional<TemplateInfo> getSystemMessageInfo() {
        return this.systemMessageInfo;
    }

    public UserMessageInfo getUserMessageInfo() {
        return this.userMessageInfo;
    }

    public Optional<Integer> getMemoryIdParamPosition() {
        return this.memoryIdParamPosition;
    }

    public boolean isRequiresModeration() {
        return this.requiresModeration;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Optional<MetricsTimedInfo> getMetricsTimedInfo() {
        return this.metricsTimedInfo;
    }

    public Optional<MetricsCountedInfo> getMetricsCountedInfo() {
        return this.metricsCountedInfo;
    }

    public Optional<SpanInfo> getSpanInfo() {
        return this.spanInfo;
    }

    public static class UserMessageInfo {
        private final Optional<TemplateInfo> template;
        private final Optional<Integer> paramPosition;
        private final Optional<String> instructions;
        private final Optional<Integer> userNameParamPosition;

        @RecordableConstructor
        public UserMessageInfo(Optional<TemplateInfo> template, Optional<Integer> paramPosition, Optional<String> instructions, Optional<Integer> userNameParamPosition) {
            this.template = template;
            this.paramPosition = paramPosition;
            this.instructions = instructions;
            this.userNameParamPosition = userNameParamPosition;
        }

        public static UserMessageInfo fromMethodParam(int paramPosition, String instructions, Optional<Integer> userNameParamPosition) {
            return new UserMessageInfo(Optional.empty(), Optional.of(paramPosition), Optional.of(instructions), userNameParamPosition);
        }

        public static UserMessageInfo fromTemplate(TemplateInfo templateInfo, Optional<Integer> userNameParamPosition) {
            return new UserMessageInfo(Optional.of(templateInfo), Optional.empty(), Optional.empty(), userNameParamPosition);
        }

        public Optional<TemplateInfo> getTemplate() {
            return this.template;
        }

        public Optional<Integer> getParamPosition() {
            return this.paramPosition;
        }

        public Optional<String> getInstructions() {
            return this.instructions;
        }

        public Optional<Integer> getUserNameParamPosition() {
            return this.userNameParamPosition;
        }
    }

    public static class SpanInfo {
        private final String name;

        @RecordableConstructor
        public SpanInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class MetricsCountedInfo {
        private final String name;
        private final boolean recordFailuresOnly;
        private final String[] extraTags;
        private final String description;

        @RecordableConstructor
        public MetricsCountedInfo(String name, String[] extraTags, boolean recordFailuresOnly, String description) {
            this.name = name;
            this.extraTags = extraTags;
            this.recordFailuresOnly = recordFailuresOnly;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String[] getExtraTags() {
            return this.extraTags;
        }

        public boolean isRecordFailuresOnly() {
            return this.recordFailuresOnly;
        }

        public String getDescription() {
            return this.description;
        }

        public static class Builder {
            private final String name;
            private String[] extraTags = new String[0];
            private boolean recordFailuresOnly = false;
            private String description = "";

            public Builder(String name) {
                this.name = name;
            }

            public Builder setExtraTags(String[] extraTags) {
                this.extraTags = extraTags;
                return this;
            }

            public Builder setRecordFailuresOnly(boolean recordFailuresOnly) {
                this.recordFailuresOnly = recordFailuresOnly;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public MetricsCountedInfo build() {
                return new MetricsCountedInfo(this.name, this.extraTags, this.recordFailuresOnly, this.description);
            }
        }
    }

    public static class MetricsTimedInfo {
        private final String name;
        private final boolean longTask;
        private final String[] extraTags;
        private final double[] percentiles;
        private final boolean histogram;
        private final String description;

        @RecordableConstructor
        public MetricsTimedInfo(String name, boolean longTask, String[] extraTags, double[] percentiles, boolean histogram, String description) {
            this.name = name;
            this.longTask = longTask;
            this.extraTags = extraTags;
            this.percentiles = percentiles;
            this.histogram = histogram;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLongTask() {
            return this.longTask;
        }

        public String[] getExtraTags() {
            return this.extraTags;
        }

        public double[] getPercentiles() {
            return this.percentiles;
        }

        public boolean isHistogram() {
            return this.histogram;
        }

        public String getDescription() {
            return this.description;
        }

        public static class Builder {
            private final String name;
            private boolean longTask = false;
            private String[] extraTags = new String[0];
            private double[] percentiles = new double[0];
            private boolean histogram = false;
            private String description = "";

            public Builder(String name) {
                this.name = name;
            }

            public Builder setLongTask(boolean longTask) {
                this.longTask = longTask;
                return this;
            }

            public Builder setExtraTags(String[] extraTags) {
                this.extraTags = extraTags;
                return this;
            }

            public Builder setPercentiles(double[] percentiles) {
                this.percentiles = percentiles;
                return this;
            }

            public Builder setHistogram(boolean histogram) {
                this.histogram = histogram;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public MetricsTimedInfo build() {
                return new MetricsTimedInfo(this.name, this.longTask, this.extraTags, this.percentiles, this.histogram, this.description);
            }
        }
    }

    public static class TemplateInfo {
        private final String text;
        private final Map<String, Integer> nameToParamPosition;

        @RecordableConstructor
        public TemplateInfo(String text, Map<String, Integer> nameToParamPosition) {
            this.text = text;
            this.nameToParamPosition = nameToParamPosition;
        }

        public String getText() {
            return this.text;
        }

        public Map<String, Integer> getNameToParamPosition() {
            return this.nameToParamPosition;
        }
    }
}

