/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.service.AiServiceContext;
import io.quarkiverse.langchain4j.RemovableChatMemoryProvider;
import io.quarkiverse.langchain4j.audit.AuditService;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class QuarkusAiServiceContext
extends AiServiceContext {
    public AuditService auditService;
    public Set<Object> usedMemoryIds = ConcurrentHashMap.newKeySet();

    public QuarkusAiServiceContext(Class<?> aiServiceClass) {
        super(aiServiceClass);
    }

    public void close() {
        this.removeChatMemories();
    }

    private void removeChatMemories() {
        if (this.usedMemoryIds.isEmpty()) {
            return;
        }
        RemovableChatMemoryProvider removableChatMemoryProvider = null;
        if (this.chatMemoryProvider instanceof RemovableChatMemoryProvider) {
            removableChatMemoryProvider = (RemovableChatMemoryProvider)this.chatMemoryProvider;
        }
        for (Object memoryId : this.usedMemoryIds) {
            if (removableChatMemoryProvider != null) {
                removableChatMemoryProvider.remove(memoryId);
            }
            this.chatMemories.remove(memoryId);
        }
    }
}

