/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j;

import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.spi.services.AiServicesFactory;
import io.quarkiverse.langchain4j.audit.AuditService;
import io.quarkiverse.langchain4j.runtime.AiServicesRecorder;
import io.quarkiverse.langchain4j.runtime.ToolsRecorder;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class QuarkusAiServicesFactory
implements AiServicesFactory {
    public <T> QuarkusAiServices<T> create(AiServiceContext context) {
        if (context instanceof QuarkusAiServiceContext) {
            return new QuarkusAiServices(context);
        }
        return new QuarkusAiServices(new QuarkusAiServiceContext(context.aiServiceClass));
    }

    public static class QuarkusAiServices<T>
    extends AiServices<T> {
        public QuarkusAiServices(AiServiceContext context) {
            super(context);
        }

        public AiServices<T> tools(List<Object> objectsWithTools) {
            this.context.toolSpecifications = new ArrayList();
            this.context.toolExecutors = new HashMap();
            ToolsRecorder.populateToolMetadata(objectsWithTools, this.context.toolSpecifications, this.context.toolExecutors);
            return this;
        }

        public AiServices<T> auditService(AuditService auditService) {
            ((QuarkusAiServiceContext)this.context).auditService = auditService;
            return this;
        }

        public T build() {
            Class aiServiceClass = this.context.aiServiceClass;
            AiServiceClassCreateInfo classCreateInfo = AiServicesRecorder.getMetadata().get(aiServiceClass.getName());
            if (classCreateInfo == null) {
                throw new RuntimeException("Quarkus was not able to determine class '" + aiServiceClass.getName() + "' as an AiService at build time. Consider annotating the class with '@CreatedAware'");
            }
            this.performBasicValidation();
            Collection<AiServiceMethodCreateInfo> methodCreateInfos = classCreateInfo.methodMap().values();
            for (AiServiceMethodCreateInfo methodCreateInfo : methodCreateInfos) {
                if (!methodCreateInfo.isRequiresModeration() || this.context.moderationModel != null) continue;
                throw IllegalConfigurationException.illegalConfiguration((String)"The @Moderate annotation is present, but the moderationModel is not set up. Please ensure a valid moderationModel is configured before using the @Moderate annotation.");
            }
            try {
                return (T)Class.forName(classCreateInfo.implClassName(), true, Thread.currentThread().getContextClassLoader()).getConstructor(QuarkusAiServiceContext.class).newInstance(new Object[]{(QuarkusAiServiceContext)this.context});
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create class '" + classCreateInfo.implClassName(), e);
            }
        }
    }

    public static class InstanceHolder {
        public static final QuarkusAiServicesFactory INSTANCE = new QuarkusAiServicesFactory();
    }
}

