/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.retriever.Retriever;
import dev.langchain4j.service.AiServices;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.QuarkusAiServicesFactory;
import io.quarkiverse.langchain4j.RegisterAiService;
import io.quarkiverse.langchain4j.audit.AuditService;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.DeclarativeAiServiceCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class AiServicesRecorder {
    private static final TypeLiteral<Instance<Retriever<TextSegment>>> RETRIEVER_INSTANCE_TYPE_LITERAL = new TypeLiteral<Instance<Retriever<TextSegment>>>(){};
    private static final TypeLiteral<Instance<AuditService>> AUDIT_SERVICE_TYPE_LITERAL = new TypeLiteral<Instance<AuditService>>(){};
    private static final TypeLiteral<Instance<RetrievalAugmentor>> RETRIEVAL_AUGMENTOR_TYPE_LITERAL = new TypeLiteral<Instance<RetrievalAugmentor>>(){};
    private static final Map<String, AiServiceClassCreateInfo> metadata = new HashMap<String, AiServiceClassCreateInfo>();

    public void setMetadata(Map<String, AiServiceClassCreateInfo> metadata) {
        AiServicesRecorder.metadata.putAll(metadata);
    }

    public static Map<String, AiServiceClassCreateInfo> getMetadata() {
        return metadata;
    }

    public static void clearMetadata() {
        metadata.clear();
    }

    public static AiServiceMethodCreateInfo getAiServiceMethodCreateInfo(String className, String methodId) {
        AiServiceClassCreateInfo classCreateInfo = metadata.get(className);
        if (classCreateInfo == null) {
            throw new RuntimeException("Quarkus was not able to determine class '" + className + "' as an AiService at build time. Consider annotating the clas with @CreatedAware");
        }
        AiServiceMethodCreateInfo methodCreateInfo = classCreateInfo.getMethodMap().get(methodId);
        if (methodCreateInfo == null) {
            throw new IllegalStateException("Unable to locate method metadata for descriptor '" + methodId + "'. Please report this issue to the maintainers");
        }
        return methodCreateInfo;
    }

    public <T> Function<SyntheticCreationalContext<T>, T> createDeclarativeAiService(final DeclarativeAiServiceCreateInfo info) {
        return new Function<SyntheticCreationalContext<T>, T>(){

            @Override
            public T apply(SyntheticCreationalContext<T> creationalContext) {
                try {
                    Object instance;
                    Supplier supplier;
                    Class<?> serviceClass = Thread.currentThread().getContextClassLoader().loadClass(info.getServiceClassName());
                    QuarkusAiServiceContext aiServiceContext = new QuarkusAiServiceContext(serviceClass);
                    AiServices quarkusAiServices = QuarkusAiServicesFactory.InstanceHolder.INSTANCE.create(aiServiceContext);
                    if (info.getLanguageModelSupplierClassName() != null) {
                        Supplier supplier2 = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.getLanguageModelSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        quarkusAiServices.chatLanguageModel((ChatLanguageModel)supplier2.get());
                    } else if (NamedModelUtil.isDefault(info.getChatModelName())) {
                        quarkusAiServices.chatLanguageModel((ChatLanguageModel)creationalContext.getInjectedReference(ChatLanguageModel.class, new Annotation[0]));
                        if (info.getNeedsStreamingChatModel()) {
                            quarkusAiServices.streamingChatLanguageModel((StreamingChatLanguageModel)creationalContext.getInjectedReference(StreamingChatLanguageModel.class, new Annotation[0]));
                        }
                    } else {
                        quarkusAiServices.chatLanguageModel((ChatLanguageModel)creationalContext.getInjectedReference(ChatLanguageModel.class, new Annotation[]{ModelName.Literal.of(info.getChatModelName())}));
                        if (info.getNeedsStreamingChatModel()) {
                            quarkusAiServices.streamingChatLanguageModel((StreamingChatLanguageModel)creationalContext.getInjectedReference(StreamingChatLanguageModel.class, new Annotation[]{ModelName.Literal.of(info.getChatModelName())}));
                        }
                    }
                    List<String> toolsClasses = info.getToolsClassNames();
                    if (toolsClasses != null && !toolsClasses.isEmpty()) {
                        ArrayList<Object> tools = new ArrayList<Object>(toolsClasses.size());
                        for (String toolClass : toolsClasses) {
                            Object tool = creationalContext.getInjectedReference(Thread.currentThread().getContextClassLoader().loadClass(toolClass), new Annotation[0]);
                            tools.add(tool);
                        }
                        quarkusAiServices.tools(tools);
                    }
                    if (info.getChatMemoryProviderSupplierClassName() != null) {
                        if (RegisterAiService.BeanChatMemoryProviderSupplier.class.getName().equals(info.getChatMemoryProviderSupplierClassName())) {
                            quarkusAiServices.chatMemoryProvider((ChatMemoryProvider)creationalContext.getInjectedReference(ChatMemoryProvider.class, new Annotation[0]));
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.getChatMemoryProviderSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.chatMemoryProvider((ChatMemoryProvider)supplier.get());
                        }
                    }
                    if (info.getRetrieverClassName() != null) {
                        quarkusAiServices.retriever((Retriever)creationalContext.getInjectedReference(Thread.currentThread().getContextClassLoader().loadClass(info.getRetrieverClassName()), new Annotation[0]));
                    }
                    if (info.getRetrievalAugmentorSupplierClassName() != null) {
                        if (RegisterAiService.BeanIfExistsRetrievalAugmentorSupplier.class.getName().equals(info.getRetrievalAugmentorSupplierClassName())) {
                            instance = (Instance)creationalContext.getInjectedReference(RETRIEVAL_AUGMENTOR_TYPE_LITERAL, new Annotation[0]);
                            if (instance.isResolvable()) {
                                quarkusAiServices.retrievalAugmentor((RetrievalAugmentor)instance.get());
                            }
                        } else {
                            try {
                                instance = (Supplier)creationalContext.getInjectedReference(Thread.currentThread().getContextClassLoader().loadClass(info.getRetrievalAugmentorSupplierClassName()), new Annotation[0]);
                                quarkusAiServices.retrievalAugmentor((RetrievalAugmentor)instance.get());
                            }
                            catch (IllegalArgumentException e) {
                                Supplier supplier3 = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.getRetrievalAugmentorSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                                quarkusAiServices.retrievalAugmentor((RetrievalAugmentor)supplier3.get());
                            }
                        }
                    }
                    if (info.getAuditServiceClassSupplierName() != null) {
                        if (RegisterAiService.BeanIfExistsAuditServiceSupplier.class.getName().equals(info.getAuditServiceClassSupplierName())) {
                            instance = (Instance)creationalContext.getInjectedReference(AUDIT_SERVICE_TYPE_LITERAL, new Annotation[0]);
                            if (instance.isResolvable()) {
                                quarkusAiServices.auditService((AuditService)instance.get());
                            }
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.getAuditServiceClassSupplierName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.auditService((AuditService)supplier.get());
                        }
                    }
                    if (info.getModerationModelSupplierClassName() != null && info.getNeedsModerationModel()) {
                        if (RegisterAiService.BeanIfExistsModerationModelSupplier.class.getName().equals(info.getModerationModelSupplierClassName())) {
                            if (NamedModelUtil.isDefault(info.getModerationModelName())) {
                                quarkusAiServices.moderationModel((ModerationModel)creationalContext.getInjectedReference(ModerationModel.class, new Annotation[0]));
                            } else {
                                quarkusAiServices.moderationModel((ModerationModel)creationalContext.getInjectedReference(ModerationModel.class, new Annotation[]{ModelName.Literal.of(info.getModerationModelName())}));
                            }
                        } else {
                            supplier = (Supplier)Thread.currentThread().getContextClassLoader().loadClass(info.getModerationModelSupplierClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            quarkusAiServices.moderationModel((ModerationModel)supplier.get());
                        }
                    }
                    return (Object)aiServiceContext;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

