/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import dev.langchain4j.internal.Json;
import dev.langchain4j.spi.json.JsonCodecFactory;
import io.quarkus.arc.Arc;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.util.Map;

public class QuarkusJsonCodecFactory
implements JsonCodecFactory {
    public Json.JsonCodec create() {
        return new Codec();
    }

    private static class Codec
    implements Json.JsonCodec {
        private Codec() {
        }

        public String toJson(Object o) {
            try {
                return ObjectMapperHolder.WRITER.writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        }

        public <T> T fromJson(String json, Class<T> type) {
            try {
                return (T)ObjectMapperHolder.MAPPER.readValue(json, type);
            }
            catch (JsonProcessingException e) {
                if (e instanceof JsonParseException && type.isEnum()) {
                    Class<Enum> enumClass = type.asSubclass(Enum.class);
                    return (T)Enum.valueOf(enumClass, json);
                }
                throw new UncheckedIOException((IOException)((Object)e));
            }
        }

        public InputStream toInputStream(Object o, Class<?> type) throws IOException {
            return new ByteArrayInputStream(ObjectMapperHolder.WRITER.writeValueAsBytes(o));
        }
    }

    public static class SnakeCaseObjectMapperHolder {
        public static final ObjectMapper MAPPER = ((ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get()).copy().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class ObjectMapperHolder {
        public static final ObjectMapper MAPPER;
        public static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE;
        private static final ObjectWriter WRITER;

        static {
            MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
            MAPPER = ((ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get()).copy().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            WRITER = MAPPER.writerWithDefaultPrettyPrinter();
        }
    }
}

