/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.UserMessage;
import java.io.IOException;
import java.util.ArrayList;

public class UserMessageDeserializer
extends StdDeserializer<UserMessage> {
    public UserMessageDeserializer() {
        super(UserMessage.class);
    }

    public UserMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = null;
        String name = null;
        ArrayList<Content> contents = null;
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String key;
            switch (key = p.getCurrentName()) {
                case "text": {
                    text = p.getText();
                    break;
                }
                case "name": {
                    name = p.getText();
                    break;
                }
                case "contents": {
                    if (p.currentToken() == JsonToken.FIELD_NAME) {
                        p.nextToken();
                    }
                    if (p.currentToken() != JsonToken.START_ARRAY) {
                        throw ValueInstantiationException.from((JsonParser)p, (String)("Cannot construct instance of `dev.langchain4j.data.message.UserMessage`, problem: expected `" + p.currentToken() + "` to be start of array"), (JavaType)ctxt.constructType(UserMessage.class));
                    }
                    contents = new ArrayList<Content>();
                    while (p.nextToken() != JsonToken.END_ARRAY) {
                        contents.add((Content)ctxt.readValue(p, Content.class));
                    }
                    break;
                }
            }
        }
        if (text != null) {
            if (name == null) {
                return new UserMessage(text);
            }
            return new UserMessage(name, text);
        }
        if (contents != null) {
            if (name == null) {
                return new UserMessage(contents);
            }
            return new UserMessage(name, contents);
        }
        throw ValueInstantiationException.from((JsonParser)p, (String)"Cannot construct instance of `dev.langchain4j.data.message.UserMessage`, problem: No `text` or `contents` field present", (JavaType)ctxt.constructType(UserMessage.class));
    }
}

