/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import io.quarkiverse.langchain4j.runtime.tool.QuarkusToolExecutor;
import io.quarkus.arc.All;
import io.quarkus.arc.Unremovable;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

@Singleton
@Unremovable
public class QuarkusToolExecutorFactory {
    private final List<QuarkusToolExecutor.Wrapper> wrappers;

    public QuarkusToolExecutorFactory(@All List<QuarkusToolExecutor.Wrapper> wrappers) {
        this.wrappers = wrappers;
    }

    public QuarkusToolExecutor create(final QuarkusToolExecutor.Context context) {
        if (this.wrappers.isEmpty()) {
            return new QuarkusToolExecutor(context);
        }
        return new QuarkusToolExecutor(context){
            final QuarkusToolExecutor originalTool;
            {
                super(context3);
                this.originalTool = new QuarkusToolExecutor(context);
            }

            @Override
            public String execute(ToolExecutionRequest toolExecutionRequest, final Object memoryId) {
                AtomicReference<1> funRef = new AtomicReference<1>(new BiFunction<ToolExecutionRequest, Object, String>(){

                    @Override
                    public String apply(ToolExecutionRequest toolExecutionRequest, Object o) {
                        return originalTool.execute(toolExecutionRequest, memoryId);
                    }
                });
                for (final QuarkusToolExecutor.Wrapper wrapper : QuarkusToolExecutorFactory.this.wrappers) {
                    final BiFunction currentFun = funRef.get();
                    BiFunction<ToolExecutionRequest, Object, String> newFunction = new BiFunction<ToolExecutionRequest, Object, String>(){

                        @Override
                        public String apply(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
                            return wrapper.wrap(toolExecutionRequest, memoryId, currentFun);
                        }
                    };
                    funRef.set(newFunction);
                }
                return (String)((BiFunction)funRef.get()).apply(toolExecutionRequest, memoryId);
            }
        };
    }
}

