/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.tool;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolExecutor;
import dev.langchain4j.internal.Json;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.runtime.prompt.Mappable;
import io.quarkiverse.langchain4j.runtime.tool.ToolInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.jboss.logging.Logger;

public class QuarkusToolExecutor
implements ToolExecutor {
    private static final Logger log = Logger.getLogger(QuarkusToolExecutor.class);
    private final Object tool;
    private final String toolInvokerName;
    private final String methodName;
    private final String argumentMapperClassName;

    public QuarkusToolExecutor(Object tool, String toolInvokerName, String methodName, String argumentMapperClassName) {
        this.tool = tool;
        this.toolInvokerName = toolInvokerName;
        this.methodName = methodName;
        this.argumentMapperClassName = argumentMapperClassName;
    }

    public String execute(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
        log.debugv("About to execute {0}", (Object)toolExecutionRequest);
        ToolInvoker invokerInstance = this.createInvokerInstance();
        Object[] params = this.prepareArguments(toolExecutionRequest, invokerInstance.methodMetadata());
        try {
            if (log.isDebugEnabled()) {
                log.debugv("Attempting to invoke tool '{0}' with parameters '{1}'", this.tool, (Object)Arrays.toString(params));
            }
            Object invocationResult = invokerInstance.invoke(this.tool, params);
            String result = QuarkusToolExecutor.handleResult(invokerInstance, invocationResult);
            log.debugv("Tool execution result: '{0}'", (Object)result);
            return result;
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            log.error((Object)("Error while executing tool '" + this.tool.getClass() + "'"), (Throwable)e);
            return e.getMessage();
        }
    }

    private static String handleResult(ToolInvoker invokerInstance, Object invocationResult) {
        if (invokerInstance.methodMetadata().isReturnsVoid()) {
            return "Success";
        }
        return Json.toJson((Object)invocationResult);
    }

    private ToolInvoker createInvokerInstance() {
        ToolInvoker invokerInstance;
        try {
            invokerInstance = (ToolInvoker)Class.forName(this.toolInvokerName, true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create instance of '" + this.toolInvokerName + "'. Please report this issue to the maintainers", e);
        }
        return invokerInstance;
    }

    private Object[] prepareArguments(ToolExecutionRequest toolExecutionRequest, ToolInvoker.MethodMetadata methodMetadata) {
        Map<String, Object> argumentsFromRequest;
        String argumentsJsonStr = toolExecutionRequest.arguments();
        try {
            log.debugv("Attempting to convert '{0}' JSON string into args map", (Object)argumentsJsonStr);
            argumentsFromRequest = this.convertJsonToArguments(argumentsJsonStr);
            log.debugv("Converted '{0}' JSON string into args map '{1}'", (Object)argumentsJsonStr, argumentsFromRequest);
        }
        catch (JsonProcessingException e) {
            log.error((Object)e);
            this.invalidMethodParams(argumentsJsonStr);
            return null;
        }
        if (argumentsFromRequest.size() != methodMetadata.getNameToParamPosition().size()) {
            this.invalidMethodParams(argumentsJsonStr);
        }
        Object[] finalArgs = new Object[argumentsFromRequest.size()];
        for (Map.Entry<String, Object> entry : argumentsFromRequest.entrySet()) {
            Integer pos = methodMetadata.getNameToParamPosition().get(entry.getKey());
            if (pos == null) {
                this.invalidMethodParams(argumentsJsonStr);
                continue;
            }
            finalArgs[pos.intValue()] = entry.getValue();
        }
        return finalArgs;
    }

    private Map<String, Object> convertJsonToArguments(String argumentsJsonStr) throws JsonProcessingException {
        Mappable mappable = (Mappable)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.readValue(argumentsJsonStr, this.loadMapperClass());
        return mappable.obtainFieldValuesMap();
    }

    private Class<? extends Mappable> loadMapperClass() {
        try {
            return Class.forName(this.argumentMapperClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load argument mapper of '" + this.toolInvokerName + "'. Please report this issue to the maintainers", e);
        }
    }

    private void invalidMethodParams(String argumentsJsonStr) {
        throw new IllegalArgumentException("params '" + argumentsJsonStr + "' from request do not map onto the parameters needed by '" + this.tool.getClass().getName() + "#" + this.methodName + "'");
    }
}

