/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.graalvm;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import dev.langchain4j.data.message.ChatMessageJsonCodec;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.internal.Json;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.spi.prompt.PromptTemplateFactory;
import dev.langchain4j.spi.prompt.structured.StructuredPromptFactory;
import io.quarkiverse.langchain4j.QuarkusAiServicesFactory;
import io.quarkiverse.langchain4j.QuarkusChatMessageJsonCodecFactory;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.QuarkusPromptTemplateFactory;
import io.quarkiverse.langchain4j.QuarkusStructuredPromptFactory;
import java.lang.reflect.Field;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.ext.ExtensionNotLoadedException;

public class Substitutions {

    @TargetClass(value=ExtensionLoader.class)
    static final class Target_ExtensionLoader {
        Target_ExtensionLoader() {
        }

        @Substitute
        public static <T> T instantiateExtension(Class<T> clazz, String extensionClassName) {
            try {
                Class<?> extClazz = Class.forName(extensionClassName);
                if (clazz.isAssignableFrom(extClazz)) {
                    try {
                        return (T)extClazz.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new ExtensionNotLoadedException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        Field instanceField;
                        try {
                            instanceField = extClazz.getDeclaredField("INSTANCE");
                        }
                        catch (NoSuchFieldException | SecurityException e1) {
                            throw new ExtensionNotLoadedException((Throwable)e1);
                        }
                        if (instanceField != null) {
                            try {
                                return (T)instanceField.get(null);
                            }
                            catch (IllegalAccessException | IllegalArgumentException e1) {
                                throw new ExtensionNotLoadedException((Throwable)e1);
                            }
                        }
                        throw new ExtensionNotLoadedException((Throwable)e);
                    }
                }
                throw new ExtensionNotLoadedException("Extension class '" + extClazz.getName() + "' needs to have type: " + clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ExtensionNotLoadedException("Unable to find implementation for " + clazz.getName() + ", the class or service " + extensionClassName + " could not be located!");
            }
        }
    }

    @TargetClass(value=ChatMessageSerializer.class)
    static final class Target_ChatMessageSerializer {
        Target_ChatMessageSerializer() {
        }

        @Substitute
        private static ChatMessageJsonCodec loadCodec() {
            return new QuarkusChatMessageJsonCodecFactory().create();
        }
    }

    @TargetClass(value=Json.class)
    static final class Target_Json {
        Target_Json() {
        }

        @Substitute
        private static Json.JsonCodec loadCodec() {
            return new QuarkusJsonCodecFactory().create();
        }
    }

    @TargetClass(value=AiServices.class)
    static final class Target_AiServices {
        Target_AiServices() {
        }

        @Substitute
        public static <T> AiServices<T> builder(Class<T> aiService) {
            return new QuarkusAiServicesFactory.QuarkusAiServices(new AiServiceContext(aiService));
        }
    }

    @TargetClass(value=StructuredPromptProcessor.class)
    static final class Target_StructuredPromptProcessor {
        Target_StructuredPromptProcessor() {
        }

        @Substitute
        private static StructuredPromptFactory factory() {
            return new QuarkusStructuredPromptFactory();
        }
    }

    @TargetClass(value=PromptTemplate.class)
    static final class Target_PromptTemplate {
        Target_PromptTemplate() {
        }

        @Substitute
        private static PromptTemplateFactory factory() {
            return new QuarkusPromptTemplateFactory();
        }
    }
}

