/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolExecutor;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.ServiceOutputParser;
import dev.langchain4j.service.TokenStream;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class MethodImplementationSupport {
    private static final Logger log = Logger.getLogger(MethodImplementationSupport.class);

    public static Object implement(AiServiceContext context, AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
        List<ChatMessage> messages;
        Optional<SystemMessage> systemMessage = MethodImplementationSupport.prepareSystemMessage(createInfo, methodArgs);
        UserMessage userMessage = MethodImplementationSupport.prepareUserMessage(context, createInfo, methodArgs);
        if (context.retriever != null) {
            List relevant = context.retriever.findRelevant(userMessage.text());
            if (relevant == null || relevant.isEmpty()) {
                log.debug((Object)"No relevant information was found");
            } else {
                String relevantConcatenated = relevant.stream().map(TextSegment::text).collect(Collectors.joining("\n\n"));
                log.debugv("Retrieved relevant information:\n{0}\n", (Object)relevantConcatenated);
                userMessage = UserMessage.userMessage((String)(userMessage.text() + "\n\nHere is some information that might be useful for answering:\n\n" + relevantConcatenated));
            }
        }
        Object memoryId = MethodImplementationSupport.memoryId(createInfo, methodArgs).orElse("default");
        if (context.hasChatMemory()) {
            ChatMemory chatMemory = context.chatMemory(memoryId);
            if (systemMessage.isPresent()) {
                chatMemory.add((ChatMessage)systemMessage.get());
            }
            chatMemory.add((ChatMessage)userMessage);
        }
        if (context.hasChatMemory()) {
            messages = context.chatMemory(memoryId).messages();
        } else {
            messages = new ArrayList();
            systemMessage.ifPresent(messages::add);
            messages.add((ChatMessage)userMessage);
        }
        Class<?> returnType = createInfo.getReturnType();
        if (returnType.equals(TokenStream.class)) {
            return new AiServiceTokenStream(messages, context, memoryId);
        }
        Future<Moderation> moderationFuture = MethodImplementationSupport.triggerModerationIfNeeded(context, createInfo, messages);
        log.debug((Object)"Attempting to obtain AI response");
        Response response = context.toolSpecifications != null ? context.chatModel.generate(messages, context.toolSpecifications) : context.chatModel.generate(messages);
        log.debug((Object)"AI response obtained");
        AiServices.verifyModerationIfNeeded(moderationFuture);
        while (true) {
            ToolExecutionRequest toolExecutionRequest;
            if (context.hasChatMemory()) {
                context.chatMemory(memoryId).add((ChatMessage)response.content());
            }
            if ((toolExecutionRequest = ((AiMessage)response.content()).toolExecutionRequest()) == null) break;
            ToolExecutor toolExecutor = (ToolExecutor)context.toolExecutors.get(toolExecutionRequest.name());
            log.debugv("Attempting to execute tool {0}", (Object)toolExecutionRequest);
            String toolExecutionResult = toolExecutor.execute(toolExecutionRequest, memoryId);
            log.debugv("Result of {0} is '{1}'", (Object)toolExecutionRequest, (Object)toolExecutionResult);
            ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.toolExecutionResultMessage((String)toolExecutionRequest.name(), (String)toolExecutionResult);
            ChatMemory chatMemory = context.chatMemory(memoryId);
            chatMemory.add((ChatMessage)toolExecutionResultMessage);
            log.debug((Object)"Attempting to obtain AI response");
            response = context.chatModel.generate(chatMemory.messages(), context.toolSpecifications);
            log.debug((Object)"AI response obtained");
        }
        log.debug((Object)"No tool execution request found - computation is complete");
        return ServiceOutputParser.parse((Response)response, returnType);
    }

    private static Future<Moderation> triggerModerationIfNeeded(final AiServiceContext context, AiServiceMethodCreateInfo createInfo, final List<ChatMessage> messages) {
        Future<Moderation> moderationFuture = null;
        if (createInfo.isRequiresModeration()) {
            log.debug((Object)"Moderation is required and it will be executed in the background");
            ExecutorService defaultExecutor = (ExecutorService)Infrastructure.getDefaultExecutor();
            moderationFuture = defaultExecutor.submit(new Callable<Moderation>(){

                @Override
                public Moderation call() {
                    List messagesToModerate = AiServices.removeToolMessages((List)messages);
                    log.debug((Object)"Attempting to moderate messages");
                    Moderation result = (Moderation)context.moderationModel.moderate(messagesToModerate).content();
                    log.debug((Object)"Moderation completed");
                    return result;
                }
            });
        }
        return moderationFuture;
    }

    private static Optional<SystemMessage> prepareSystemMessage(AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
        if (createInfo.getSystemMessageInfo().isEmpty()) {
            return Optional.empty();
        }
        AiServiceMethodCreateInfo.TemplateInfo systemMessageInfo = createInfo.getSystemMessageInfo().get();
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        Map<String, Integer> nameToParamPosition = systemMessageInfo.getNameToParamPosition();
        for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
            templateParams.put(entry.getKey(), methodArgs[entry.getValue()]);
        }
        Prompt prompt = PromptTemplate.from((String)systemMessageInfo.getText()).apply(templateParams);
        return Optional.of(prompt.toSystemMessage());
    }

    private static UserMessage prepareUserMessage(AiServiceContext context, AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
        AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo = createInfo.getUserMessageInfo();
        String userName = null;
        if (userMessageInfo.getUserNameParamPosition().isPresent()) {
            userName = methodArgs[userMessageInfo.getUserNameParamPosition().get()].toString();
        }
        if (userMessageInfo.getTemplate().isPresent()) {
            AiServiceMethodCreateInfo.TemplateInfo templateInfo = userMessageInfo.getTemplate().get();
            HashMap<String, Object> templateParams = new HashMap<String, Object>();
            Map<String, Integer> nameToParamPosition = templateInfo.getNameToParamPosition();
            for (Map.Entry<String, Integer> entry : nameToParamPosition.entrySet()) {
                Object value = MethodImplementationSupport.transformTemplateParamValue(methodArgs[entry.getValue()]);
                templateParams.put(entry.getKey(), value);
            }
            Prompt prompt = PromptTemplate.from((String)templateInfo.getText()).apply(templateParams);
            return UserMessage.userMessage((String)userName, (String)prompt.text());
        }
        if (userMessageInfo.getParamPosition().isPresent()) {
            Object argValue = methodArgs[userMessageInfo.getParamPosition().get()];
            if (argValue == null) {
                throw new IllegalArgumentException("Unable to construct UserMessage for class + " + context.aiServiceClass.getName() + "because parameter " + userMessageInfo.getParamPosition() + " is null");
            }
            return UserMessage.userMessage((String)userName, (String)(MethodImplementationSupport.toString(argValue) + userMessageInfo.getInstructions().orElse("")));
        }
        throw new IllegalStateException("Unable to construct UserMessage for class '" + context.aiServiceClass.getName() + "'. Please contact the maintainers");
    }

    private static Object transformTemplateParamValue(Object value) {
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value;
    }

    private static Optional<Object> memoryId(AiServiceMethodCreateInfo createInfo, Object[] methodArgs) {
        if (createInfo.getMemoryIdParamPosition().isPresent()) {
            return Optional.of(methodArgs[createInfo.getMemoryIdParamPosition().get()]);
        }
        return Optional.empty();
    }

    private static String toString(Object arg) {
        if (arg.getClass().isArray()) {
            return MethodImplementationSupport.arrayToString(arg);
        }
        if (arg.getClass().isAnnotationPresent(StructuredPrompt.class)) {
            return StructuredPromptProcessor.toPrompt((Object)arg).text();
        }
        return arg.toString();
    }

    private static String arrayToString(Object arg) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(arg);
        for (int i = 0; i < length; ++i) {
            sb.append(MethodImplementationSupport.toString(Array.get(arg, i)));
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

