/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.runtime.aiservice;

import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.Map;
import java.util.Optional;

public class AiServiceMethodCreateInfo {
    private final Optional<TemplateInfo> systemMessageInfo;
    private final UserMessageInfo userMessageInfo;
    private final Optional<Integer> memoryIdParamPosition;
    private final boolean requiresModeration;
    private final Class<?> returnType;

    @RecordableConstructor
    public AiServiceMethodCreateInfo(Optional<TemplateInfo> systemMessageInfo, UserMessageInfo userMessageInfo, Optional<Integer> memoryIdParamPosition, boolean requiresModeration, Class<?> returnType) {
        this.systemMessageInfo = systemMessageInfo;
        this.userMessageInfo = userMessageInfo;
        this.memoryIdParamPosition = memoryIdParamPosition;
        this.requiresModeration = requiresModeration;
        this.returnType = returnType;
    }

    public Optional<TemplateInfo> getSystemMessageInfo() {
        return this.systemMessageInfo;
    }

    public UserMessageInfo getUserMessageInfo() {
        return this.userMessageInfo;
    }

    public Optional<Integer> getMemoryIdParamPosition() {
        return this.memoryIdParamPosition;
    }

    public boolean isRequiresModeration() {
        return this.requiresModeration;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public static class UserMessageInfo {
        private final Optional<TemplateInfo> template;
        private final Optional<Integer> paramPosition;
        private final Optional<String> instructions;
        private final Optional<Integer> userNameParamPosition;

        @RecordableConstructor
        public UserMessageInfo(Optional<TemplateInfo> template, Optional<Integer> paramPosition, Optional<String> instructions, Optional<Integer> userNameParamPosition) {
            this.template = template;
            this.paramPosition = paramPosition;
            this.instructions = instructions;
            this.userNameParamPosition = userNameParamPosition;
        }

        public static UserMessageInfo fromMethodParam(int paramPosition, String instructions, Optional<Integer> userNameParamPosition) {
            return new UserMessageInfo(Optional.empty(), Optional.of(paramPosition), Optional.of(instructions), userNameParamPosition);
        }

        public static UserMessageInfo fromTemplate(TemplateInfo templateInfo, Optional<Integer> userNameParamPosition) {
            return new UserMessageInfo(Optional.of(templateInfo), Optional.empty(), Optional.empty(), userNameParamPosition);
        }

        public Optional<TemplateInfo> getTemplate() {
            return this.template;
        }

        public Optional<Integer> getParamPosition() {
            return this.paramPosition;
        }

        public Optional<String> getInstructions() {
            return this.instructions;
        }

        public Optional<Integer> getUserNameParamPosition() {
            return this.userNameParamPosition;
        }
    }

    public static class TemplateInfo {
        private final String text;
        private final Map<String, Integer> nameToParamPosition;

        @RecordableConstructor
        public TemplateInfo(String text, Map<String, Integer> nameToParamPosition) {
            this.text = text;
            this.nameToParamPosition = nameToParamPosition;
        }

        public String getText() {
            return this.text;
        }

        public Map<String, Integer> getNameToParamPosition() {
            return this.nameToParamPosition;
        }
    }
}

