/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment.devui;

import io.quarkiverse.langchain4j.deployment.DeclarativeAiServiceBuildItem;
import io.quarkiverse.langchain4j.deployment.EmbeddingModelBuildItem;
import io.quarkiverse.langchain4j.deployment.EmbeddingStoreBuildItem;
import io.quarkiverse.langchain4j.deployment.ToolsMetadataBuildItem;
import io.quarkiverse.langchain4j.deployment.devui.AiServiceInfo;
import io.quarkiverse.langchain4j.deployment.devui.ToolMethodInfo;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.devui.ChatJsonRPCService;
import io.quarkiverse.langchain4j.runtime.devui.EmbeddingStoreJsonRPCService;
import io.quarkiverse.langchain4j.runtime.tool.ToolMethodCreateInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LangChain4jDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem cardPage(List<DeclarativeAiServiceBuildItem> aiServices, ToolsMetadataBuildItem toolsMetadataBuildItem, List<EmbeddingModelBuildItem> embeddingModelBuildItem, List<EmbeddingStoreBuildItem> embeddingStoreBuildItem, List<SelectedChatModelProviderBuildItem> chatModelProviders) {
        CardPageBuildItem card = new CardPageBuildItem();
        this.addAiServicesPage(card, aiServices);
        if (toolsMetadataBuildItem != null) {
            this.addToolsPage(card, toolsMetadataBuildItem);
        }
        if (embeddingModelBuildItem.size() == 1 && embeddingStoreBuildItem.size() == 1) {
            this.addEmbeddingStorePage(card);
        }
        if (!chatModelProviders.isEmpty()) {
            this.addChatPage(card);
        }
        return card;
    }

    private void addEmbeddingStorePage(CardPageBuildItem card) {
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Embedding store")).componentLink("qwc-embedding-store.js").icon("font-awesome-solid:database"));
    }

    private void addAiServicesPage(CardPageBuildItem card, List<DeclarativeAiServiceBuildItem> aiServices) {
        ArrayList<AiServiceInfo> infos = new ArrayList<AiServiceInfo>();
        for (DeclarativeAiServiceBuildItem aiService : aiServices) {
            List<String> tools = aiService.getToolDotNames().stream().map(dotName -> dotName.toString()).toList();
            infos.add(new AiServiceInfo(aiService.getServiceClassInfo().name().toString(), tools));
        }
        card.addBuildTimeData("aiservices", infos);
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("AI Services")).componentLink("qwc-aiservices.js").staticLabel(String.valueOf(aiServices.size()))).icon("font-awesome-solid:robot"));
    }

    private void addToolsPage(CardPageBuildItem card, ToolsMetadataBuildItem metadataBuildItem) {
        ArrayList<ToolMethodInfo> infos = new ArrayList<ToolMethodInfo>();
        Map<String, List<ToolMethodCreateInfo>> metadata = metadataBuildItem.getMetadata();
        for (Map.Entry<String, List<ToolMethodCreateInfo>> toolClassEntry : metadata.entrySet()) {
            for (ToolMethodCreateInfo toolMethodCreateInfo : toolClassEntry.getValue()) {
                infos.add(new ToolMethodInfo(toolClassEntry.getKey(), toolMethodCreateInfo.getToolSpecification().name(), toolMethodCreateInfo.getToolSpecification().description()));
            }
        }
        card.addBuildTimeData("tools", infos);
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Tools")).componentLink("qwc-tools.js").staticLabel(String.valueOf(infos.size()))).icon("font-awesome-solid:toolbox"));
    }

    private void addChatPage(CardPageBuildItem card) {
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Chat")).componentLink("qwc-chat.js").icon("font-awesome-solid:comments"));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void jsonRpcProviders(BuildProducer<JsonRPCProvidersBuildItem> producers, List<EmbeddingModelBuildItem> embeddingModelBuildItem, List<EmbeddingStoreBuildItem> embeddingStoreBuildItem, List<ChatModelProviderCandidateBuildItem> chatModelCandidates) {
        if (embeddingModelBuildItem.size() == 1 && embeddingStoreBuildItem.size() == 1) {
            producers.produce((BuildItem)new JsonRPCProvidersBuildItem(EmbeddingStoreJsonRPCService.class));
        }
        if (!chatModelCandidates.isEmpty()) {
            producers.produce((BuildItem)new JsonRPCProvidersBuildItem(ChatJsonRPCService.class));
        }
    }
}

