/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class JandexUtil {
    private static final Logger log = Logger.getLogger(JandexUtil.class);

    JandexUtil() {
    }

    static Collection<ClassInfo> getAllSuperinterfaces(ClassInfo interfaceName, IndexView index) {
        HashSet<ClassInfo> result = new HashSet<ClassInfo>();
        ArrayDeque<DotName> workQueue = new ArrayDeque<DotName>();
        HashSet<DotName> alreadyProcessed = new HashSet<DotName>();
        workQueue.add(interfaceName.name());
        while (!workQueue.isEmpty()) {
            DotName iface = (DotName)workQueue.remove();
            if (!alreadyProcessed.add(iface)) continue;
            ArrayList<ClassInfo> directSuperInterfaces = new ArrayList<ClassInfo>();
            for (DotName name : interfaceName.interfaceNames()) {
                ClassInfo classInfo = index.getClassByName(name);
                if (classInfo == null) {
                    log.warn((Object)("'" + name + "' used for creating an AiService is not an interface. Attempting to create an AiService using this class will fail"));
                }
                directSuperInterfaces.add(classInfo);
            }
            for (ClassInfo directSubInterface : directSuperInterfaces) {
                result.add(directSubInterface);
                workQueue.add(directSubInterface.name());
            }
        }
        return result;
    }

    static boolean isDefault(short flags) {
        return (flags & 0x409) == 1;
    }

    static Class<?> load(Type type, ClassLoader classLoader) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            PrimitiveType prim = type.asPrimitiveType();
            switch (prim.primitive()) {
                case INT: {
                    return Integer.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
            }
            throw new RuntimeException("Unknown type " + prim.primitive());
        }
        try {
            return Class.forName(type.name().toString(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

