/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.data.document.splitter.DocumentBySentenceSplitter;
import io.quarkiverse.langchain4j.deployment.JarResourceUtil;
import io.quarkiverse.langchain4j.deployment.items.InProcessEmbeddingBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class DocumentNativeSupportProcessor {
    @BuildStep
    void onnxJni(List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems, BuildProducer<NativeImageResourcePatternsBuildItem> nativePatternProducer, BuildProducer<ReflectiveClassBuildItem> reflectionProducer) {
        if (!inProcessEmbeddingBuildItems.isEmpty()) {
            nativePatternProducer.produce((BuildItem)NativeImageResourcePatternsBuildItem.builder().includeGlobs(new String[]{"ai/onnxruntime/native/**"}).build());
            reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"opennlp.tools.sentdetect.SentenceDetectorFactory"}).build());
            reflectionProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"ai.onnxruntime.OnnxTensor"}).methods(true).build());
        }
    }

    @BuildStep
    void apachePoiRuntimeClasses(List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems, BuildProducer<RuntimeInitializedClassBuildItem> classProducer, BuildProducer<RuntimeInitializedPackageBuildItem> packageProducer) {
        Stream.of("dev.langchain4j.model.embedding.OnnxBertBiEncoder", "ai.onnxruntime.OrtEnvironment", "ai.onnxruntime.OnnxRuntime", "ai.onnxruntime.OnnxTensorLike", "ai.onnxruntime.OrtAllocator", "ai.onnxruntime.OrtSession$SessionOptions", "ai.onnxruntime.OrtSession", "org.apache.fontbox.ttf.RAFDataStream", "org.apache.fontbox.ttf.TTFParser", "org.apache.pdfbox.pdmodel.encrypetion.PublicKeySecurityHandler", "org.apache.pdfbox.pdmodel.font.FileSystemFontProvider$FSFontInfo", "org.apache.pdfbox.pdmodel.font.FontMapperImpl$DefaultFontProvider", "org.apache.pdfbox.pdmodel.font.FontMapperImpl", "org.apache.pdfbox.pdmodel.font.FontMappers$DefaultFontMapper", "org.apache.pdfbox.pdmodel.font.PDFont", "org.apache.pdfbox.pdmodel.font.PDFontLike", "org.apache.pdfbox.pdmodel.font.PDSimpleFont", "org.apache.pdfbox.pdmodel.font.PDType1Font", "org.apache.pdfbox.pdmodel.graphics.color.PDCIEDictionaryBasedColorSpace", "org.apache.pdfbox.pdmodel.PDDocument", "org.apache.pdfbox.rendering.SoftMask").filter(QuarkusClassLoader::isClassPresentAtRuntime).map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> classProducer.produce(arg_0));
        for (InProcessEmbeddingBuildItem inProcessEmbeddingBuildItem : inProcessEmbeddingBuildItems) {
            classProducer.produce((BuildItem)new RuntimeInitializedClassBuildItem(inProcessEmbeddingBuildItem.className()));
        }
        packageProducer.produce((BuildItem)new RuntimeInitializedPackageBuildItem("com.microsoft.schemas.office"));
    }

    @BuildStep
    void includeInProcessEmbeddingModels(List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems, BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<ReflectiveClassBuildItem> reflection) {
        for (InProcessEmbeddingBuildItem inProcessEmbeddingBuildItem : inProcessEmbeddingBuildItems) {
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{inProcessEmbeddingBuildItem.onnxModelPath()}));
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{inProcessEmbeddingBuildItem.vocabularyPath()}));
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{inProcessEmbeddingBuildItem.className()}).constructors(true).fields(true).methods(true).build());
        }
    }

    @BuildStep
    void openNLPResources(BuildProducer<NativeImageResourceBuildItem> producer) {
        this.registerCustomOpenNLPResources(producer);
    }

    private void registerCustomOpenNLPResources(BuildProducer<NativeImageResourceBuildItem> resourcesProducer) {
        Path langChain4jJar = JarResourceUtil.determineJarLocation(DocumentBySentenceSplitter.class);
        List names = JarResourceUtil.matchingJarEntries(langChain4jJar, e -> e.getName().endsWith(".bin")).stream().map(ZipEntry::getName).collect(Collectors.toList());
        if (!names.isEmpty()) {
            resourcesProducer.produce((BuildItem)new NativeImageResourceBuildItem(names));
        }
    }
}

