/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import io.quarkiverse.langchain4j.deployment.Langchain4jDotNames;
import io.quarkiverse.langchain4j.deployment.RequestChatModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestModerationModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.config.LangChain4jBuildConfig;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ImageModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.InProcessEmbeddingBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ModerationModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ProviderHolder;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedImageModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedModerationModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.Langchain4jRecorder;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class BeansProcessor {
    private static final String FEATURE = "langchain4j";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> producer) {
        producer.produce((BuildItem)new IndexDependencyBuildItem("dev.langchain4j", "langchain4j-core"));
    }

    @BuildStep
    public void handleProviders(BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, List<ChatModelProviderCandidateBuildItem> chatCandidateItems, List<EmbeddingModelProviderCandidateBuildItem> embeddingCandidateItems, List<ModerationModelProviderCandidateBuildItem> moderationCandidateItems, List<ImageModelProviderCandidateBuildItem> imageCandidateItems, List<RequestChatModelBeanBuildItem> requestChatModelBeanItems, List<RequestModerationModelBeanBuildItem> requestModerationModelBeanBuildItems, LangChain4jBuildConfig buildConfig, BuildProducer<SelectedChatModelProviderBuildItem> selectedChatProducer, BuildProducer<SelectedEmbeddingModelCandidateBuildItem> selectedEmbeddingProducer, BuildProducer<SelectedModerationModelProviderBuildItem> selectedModerationProducer, BuildProducer<SelectedImageModelProviderBuildItem> selectedImageProducer, List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems) {
        String provider;
        Object configNamespace;
        Optional<String> userSelectedProvider;
        HashSet<String> requestedChatModels = new HashSet<String>();
        HashSet<String> requestedStreamingChatModels = new HashSet<String>();
        HashSet<String> requestEmbeddingModels = new HashSet<String>();
        HashSet<String> requestedModerationModels = new HashSet<String>();
        HashSet<String> requestedImageModels = new HashSet<String>();
        for (InjectionPointInfo injectionPointInfo : beanDiscoveryFinished.getInjectionPoints()) {
            DotName requiredName = injectionPointInfo.getRequiredType().name();
            String modelName = this.determineModelName(injectionPointInfo);
            if (Langchain4jDotNames.CHAT_MODEL.equals((Object)requiredName)) {
                requestedChatModels.add(modelName);
                continue;
            }
            if (Langchain4jDotNames.STREAMING_CHAT_MODEL.equals((Object)requiredName)) {
                requestedStreamingChatModels.add(modelName);
                continue;
            }
            if (Langchain4jDotNames.EMBEDDING_MODEL.equals((Object)requiredName)) {
                requestEmbeddingModels.add(modelName);
                continue;
            }
            if (Langchain4jDotNames.MODERATION_MODEL.equals((Object)requiredName)) {
                requestedModerationModels.add(modelName);
                continue;
            }
            if (!Langchain4jDotNames.IMAGE_MODEL.equals((Object)requiredName)) continue;
            requestedImageModels.add(modelName);
        }
        for (RequestChatModelBeanBuildItem requestChatModelBeanBuildItem : requestChatModelBeanItems) {
            requestedChatModels.add(requestChatModelBeanBuildItem.getModelName());
        }
        for (RequestModerationModelBeanBuildItem requestModerationModelBeanBuildItem : requestModerationModelBeanBuildItems) {
            requestedModerationModels.add(requestModerationModelBeanBuildItem.getModelName());
        }
        if (!requestedChatModels.isEmpty() || !requestedStreamingChatModels.isEmpty()) {
            HashSet<String> allChatModelNames = new HashSet<String>(requestedChatModels);
            allChatModelNames.addAll(requestedStreamingChatModels);
            for (String modelName : allChatModelNames) {
                String provider2;
                String configNamespace2;
                Optional<String> userSelectedProvider2;
                if (NamedModelUtil.isDefault((String)modelName)) {
                    Optional<String> userSelectedProvider22 = buildConfig.defaultConfig().chatModel().provider();
                    String configNamespace22 = "chat-model";
                } else {
                    userSelectedProvider2 = buildConfig.namedConfig().containsKey(modelName) ? buildConfig.namedConfig().get(modelName).chatModel().provider() : Optional.empty();
                    configNamespace2 = modelName + ".chat-model";
                }
                if ((provider2 = this.selectProvider(chatCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ChatLanguageModel.class), userSelectedProvider2, "ChatLanguageModel or StreamingChatLanguageModel", configNamespace2)) == null) continue;
                selectedChatProducer.produce((BuildItem)new SelectedChatModelProviderBuildItem(provider2, modelName));
            }
        }
        for (String string : requestEmbeddingModels) {
            if (NamedModelUtil.isDefault((String)string)) {
                userSelectedProvider = buildConfig.defaultConfig().embeddingModel().provider();
                configNamespace = "embedding-model";
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).embeddingModel().provider() : Optional.empty();
                configNamespace = string + ".embedding-model";
            }
            if ((provider = this.selectEmbeddingModelProvider(inProcessEmbeddingBuildItems, embeddingCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(EmbeddingModel.class), userSelectedProvider, "EmbeddingModel", (String)configNamespace)) == null) continue;
            selectedEmbeddingProducer.produce((BuildItem)new SelectedEmbeddingModelCandidateBuildItem(provider, string));
        }
        for (String string : requestedModerationModels) {
            if (NamedModelUtil.isDefault((String)string)) {
                userSelectedProvider = buildConfig.defaultConfig().moderationModel().provider();
                configNamespace = "moderation-model";
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).moderationModel().provider() : Optional.empty();
                configNamespace = string + ".moderation-model";
            }
            if ((provider = this.selectProvider(moderationCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ModerationModel.class), userSelectedProvider, "ModerationModel", (String)configNamespace)) == null) continue;
            selectedModerationProducer.produce((BuildItem)new SelectedModerationModelProviderBuildItem(provider, string));
        }
        for (String string : requestedImageModels) {
            if (NamedModelUtil.isDefault((String)string)) {
                userSelectedProvider = buildConfig.defaultConfig().imageModel().provider();
                configNamespace = "image-model";
            } else {
                userSelectedProvider = buildConfig.namedConfig().containsKey(string) ? buildConfig.namedConfig().get(string).imageModel().provider() : Optional.empty();
                configNamespace = string + ".image-model";
            }
            if ((provider = this.selectProvider(imageCandidateItems, beanDiscoveryFinished.beanStream().withBeanType(ImageModel.class), userSelectedProvider, "ImageModel", (String)configNamespace)) == null) continue;
            selectedImageProducer.produce((BuildItem)new SelectedImageModelProviderBuildItem(provider, string));
        }
    }

    private String determineModelName(InjectionPointInfo ip) {
        String value;
        AnnotationInstance modelNameInstance = ip.getRequiredQualifier(Langchain4jDotNames.MODEL_NAME);
        if (modelNameInstance != null && (value = modelNameInstance.value().asString()) != null && !value.isEmpty()) {
            return value;
        }
        return "<default>";
    }

    private <T extends ProviderHolder> String selectProvider(List<T> candidateItems, BeanStream beanStream, Optional<String> userSelectedProvider, String beanType, String configNamespace) {
        List availableProviders = candidateItems.stream().map(ProviderHolder::getProvider).collect(Collectors.toList());
        if (availableProviders.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but no langchain4j providers were configured. Consider adding an extension like 'quarkus-langchain4j-openai'", beanType));
            }
            return null;
        }
        if (availableProviders.size() == 1) {
            if (userSelectedProvider.isPresent() && !((String)availableProviders.get(0)).equals(userSelectedProvider.get())) {
                throw new ConfigurationException(String.format("A %s bean with provider=%s was requested was requested via configuration, but the only provider found on the classpath is %s.", beanType, userSelectedProvider.get(), availableProviders.get(0)));
            }
            return (String)availableProviders.get(0);
        }
        if (userSelectedProvider.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but since there are multiple available providers, the 'quarkus.langchain4j.%s.provider' needs to be set to one of the available options (%s).", beanType, configNamespace, String.join((CharSequence)",", availableProviders)));
            }
            return null;
        }
        boolean matches = availableProviders.stream().anyMatch(ap -> ap.equals(userSelectedProvider.get()));
        if (matches) {
            return userSelectedProvider.get();
        }
        if (beanStream.collect().isEmpty()) {
            throw new ConfigurationException(String.format("A %s bean was requested, but the value of 'quarkus.langchain4j.%s.provider' does not match any of the available options (%s).", beanType, configNamespace, String.join((CharSequence)",", availableProviders)));
        }
        return null;
    }

    private <T extends ProviderHolder> String selectEmbeddingModelProvider(List<InProcessEmbeddingBuildItem> inProcessEmbeddingBuildItems, List<T> chatCandidateItems, BeanStream beanStream, Optional<String> userSelectedProvider, String requestedBeanName, String configNamespace) {
        List availableProviders = chatCandidateItems.stream().map(ProviderHolder::getProvider).collect(Collectors.toList());
        availableProviders.addAll(inProcessEmbeddingBuildItems.stream().map(InProcessEmbeddingBuildItem::getProvider).toList());
        if (availableProviders.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but no langchain4j providers were configured and no in-process embedding model were found on the classpath. Consider adding an extension like 'quarkus-langchain4j-openai' or one of the in-process embedding models.", requestedBeanName));
            }
            return null;
        }
        if (availableProviders.size() == 1) {
            if (userSelectedProvider.isPresent() && !((String)availableProviders.get(0)).equals(userSelectedProvider.get())) {
                throw new ConfigurationException(String.format("Embedding model provider %s was requested via configuration, but the only provider found on the classpath is %s.", userSelectedProvider.get(), availableProviders.get(0)));
            }
            return (String)availableProviders.get(0);
        }
        if (userSelectedProvider.isEmpty()) {
            if (beanStream.collect().isEmpty()) {
                throw new ConfigurationException(String.format("A %s bean was requested, but since there are multiple available providers, the 'quarkus.langchain4j.%s.provider' needs to be set to one of the available options (%s).", requestedBeanName, configNamespace, String.join((CharSequence)",", availableProviders)));
            }
            return null;
        }
        boolean matches = availableProviders.stream().anyMatch(ap -> ap.equals(userSelectedProvider.get()));
        if (matches) {
            return userSelectedProvider.get();
        }
        if (beanStream.collect().isEmpty()) {
            throw new ConfigurationException(String.format("A %s bean was requested, but the value of 'quarkus.langchain4j.%s.provider' does not match any of the available options (%s).", requestedBeanName, configNamespace, String.join((CharSequence)",", availableProviders)));
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void cleanUp(Langchain4jRecorder recorder, ShutdownContextBuildItem shutdown) {
        recorder.cleanUp((ShutdownContext)shutdown);
    }

    @BuildStep
    public void unremoveableBeans(BuildProducer<UnremovableBeanBuildItem> unremoveableProducer) {
        unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
    }
}

