/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.service.AiServices;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

class AiServicesUseAnalyzer {
    private static final String AI_SERVICES_BINARY_NAME = AiServices.class.getName().replace(".", "/");

    AiServicesUseAnalyzer() {
    }

    static Result analyze(ClassNode clazz, MethodNode method) throws AnalyzerException {
        final ArrayList<Result.Entry> analysisEntries = new ArrayList<Result.Entry>();
        Type currentClass = Type.getObjectType((String)clazz.name);
        Type currentSuperClass = Type.getObjectType((String)clazz.superName);
        List currentInterfaces = clazz.interfaces.stream().map(Type::getObjectType).collect(Collectors.toList());
        boolean isInterface = (clazz.access & 0x200) == 512;
        SimpleVerifier simpleVerifier = new SimpleVerifier(589824, currentClass, currentSuperClass, currentInterfaces, isInterface){
            private final AtomicReference<String> classNameInBuilder;
            private final AtomicBoolean chatProviderProviderUsed;
            {
                super(api, currentClass, currentSuperClass, currentClassInterfaces, isInterface);
                this.classNameInBuilder = new AtomicReference();
                this.chatProviderProviderUsed = new AtomicBoolean();
            }

            public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
                Object value;
                if (insn.getOpcode() == 18 && (value = ((LdcInsnNode)insn).cst) instanceof Type) {
                    try {
                        String className = ((Type)value).getClassName();
                        return new LdcTrackingBasicValue(Type.getObjectType((String)"java/lang/Class"), className);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.newOperation(insn);
            }

            public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
                if (insn.getType() == 5) {
                    MethodInsnNode method = (MethodInsnNode)insn;
                    if (AI_SERVICES_BINARY_NAME.equals(method.owner)) {
                        if ("builder".equals(method.name) && !values.isEmpty()) {
                            BasicValue basicValue = values.get(0);
                            if (basicValue instanceof LdcTrackingBasicValue) {
                                String createdClassName = ((LdcTrackingBasicValue)basicValue).getClassName();
                                this.classNameInBuilder.set(createdClassName);
                            }
                        } else if ("create".equals(method.name) && !values.isEmpty()) {
                            BasicValue basicValue = values.get(0);
                            if (basicValue instanceof LdcTrackingBasicValue) {
                                String createdClassName = ((LdcTrackingBasicValue)basicValue).getClassName();
                                analysisEntries.add(new Result.Entry(createdClassName, false));
                            }
                        } else if ("chatMemoryProvider".equals(method.name)) {
                            this.chatProviderProviderUsed.set(true);
                        } else if ("build".equals(method.name)) {
                            String createdClassName = this.classNameInBuilder.get();
                            if (createdClassName != null) {
                                analysisEntries.add(new Result.Entry(createdClassName, this.chatProviderProviderUsed.get()));
                            }
                            this.classNameInBuilder.set(null);
                            this.chatProviderProviderUsed.set(false);
                        }
                    }
                }
                return super.naryOperation(insn, values);
            }
        };
        Analyzer analyzer = new Analyzer((Interpreter)simpleVerifier);
        simpleVerifier.setClassLoader(Thread.currentThread().getContextClassLoader());
        analyzer.analyze(clazz.name, method);
        return new Result(analysisEntries);
    }

    static class Result {
        final List<Entry> entries;

        public Result(List<Entry> entries) {
            this.entries = entries;
        }

        static class Entry {
            final String createdClassName;
            final boolean chatMemoryProviderUsed;

            public Entry(String createdClassName, boolean chatMemoryProviderUsed) {
                this.createdClassName = createdClassName;
                this.chatMemoryProviderUsed = chatMemoryProviderUsed;
            }
        }
    }

    private static class LdcTrackingBasicValue
    extends BasicValue {
        private final String className;

        public LdcTrackingBasicValue(Type type, String className) {
            super(type);
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

