/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.deployment;

import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.service.ServiceOutputParser;
import dev.langchain4j.service.V;
import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.deployment.AiServicesUseAnalyzer;
import io.quarkiverse.langchain4j.deployment.DeclarativeAiServiceBuildItem;
import io.quarkiverse.langchain4j.deployment.ExceptionUtil;
import io.quarkiverse.langchain4j.deployment.JandexUtil;
import io.quarkiverse.langchain4j.deployment.Langchain4jDotNames;
import io.quarkiverse.langchain4j.deployment.RequestChatModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.RequestModerationModelBeanBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.AiServicesRecorder;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceClassCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.AiServiceMethodImplementationSupport;
import io.quarkiverse.langchain4j.runtime.aiservice.ChatMemoryRemovable;
import io.quarkiverse.langchain4j.runtime.aiservice.DeclarativeAiServiceCreateInfo;
import io.quarkiverse.langchain4j.runtime.aiservice.MetricsCountedWrapper;
import io.quarkiverse.langchain4j.runtime.aiservice.MetricsTimedWrapper;
import io.quarkiverse.langchain4j.runtime.aiservice.QuarkusAiServiceContext;
import io.quarkiverse.langchain4j.runtime.aiservice.SpanWrapper;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class AiServicesProcessor {
    private static final Logger log = Logger.getLogger(AiServicesProcessor.class);
    private static final DotName V = DotName.createSimple(V.class);
    public static final DotName MICROMETER_TIMED = DotName.createSimple((String)"io.micrometer.core.annotation.Timed");
    public static final DotName MICROMETER_COUNTED = DotName.createSimple((String)"io.micrometer.core.annotation.Counted");
    private static final String DEFAULT_DELIMITER = "\n";
    private static final Predicate<AnnotationInstance> IS_METHOD_PARAMETER_ANNOTATION = ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER;
    private static final Function<AnnotationInstance, Integer> METHOD_PARAMETER_POSITION_FUNCTION = ai -> ai.target().asMethodParameter().position();
    public static final MethodDescriptor OBJECT_CONSTRUCTOR = MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor RECORDER_METHOD_CREATE_INFO = MethodDescriptor.ofMethod(AiServicesRecorder.class, (String)"getAiServiceMethodCreateInfo", AiServiceMethodCreateInfo.class, (Class[])new Class[]{String.class, String.class});
    private static final MethodDescriptor SUPPORT_IMPLEMENT = MethodDescriptor.ofMethod(AiServiceMethodImplementationSupport.class, (String)"implement", Object.class, (Class[])new Class[]{AiServiceMethodImplementationSupport.Input.class});
    private static final MethodDescriptor QUARKUS_AI_SERVICES_CONTEXT_CLOSE = MethodDescriptor.ofMethod(QuarkusAiServiceContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]);
    private static final MethodDescriptor QUARKUS_AI_SERVICES_CONTEXT_REMOVE_CHAT_MEMORY_IDS = MethodDescriptor.ofMethod(QuarkusAiServiceContext.class, (String)"removeChatMemoryIds", Void.TYPE, (Class[])new Class[]{Object[].class});
    public static final DotName CDI_INSTANCE = DotName.createSimple(Instance.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String METRICS_DEFAULT_NAME = "langchain4j.aiservices";
    public static final ClassType CHAT_MODEL_CLASS_TYPE = ClassType.create((DotName)Langchain4jDotNames.CHAT_MODEL);

    @BuildStep
    public void nativeSupport(CombinedIndexBuildItem indexBuildItem, List<AiServicesMethodBuildItem> aiServicesMethodBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        IndexView index = indexBuildItem.getIndex();
        Collection instances = index.getAnnotations(Langchain4jDotNames.DESCRIPTION);
        HashSet<ClassInfo> classesUsingDescription = new HashSet<ClassInfo>();
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
            classesUsingDescription.add(instance.target().asField().declaringClass());
        }
        if (!classesUsingDescription.isEmpty()) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])classesUsingDescription.stream().map(i -> i.name().toString()).toArray(String[]::new))).fields(true).build());
        }
        HashSet<DotName> returnTypesToRegister = new HashSet<DotName>();
        for (AiServicesMethodBuildItem aiServicesMethodBuildItem : aiServicesMethodBuildItems) {
            DotName returnTypeName;
            Type type = aiServicesMethodBuildItem.methodInfo.returnType();
            if (type.kind() == Type.Kind.PRIMITIVE || (returnTypeName = type.name()).toString().startsWith("java.")) continue;
            returnTypesToRegister.add(returnTypeName);
        }
        if (!returnTypesToRegister.isEmpty()) {
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])returnTypesToRegister.stream().map(DotName::toString).toArray(String[]::new))).constructors(false).build());
        }
    }

    @BuildStep
    public void findDeclarativeServices(CombinedIndexBuildItem indexBuildItem, BuildProducer<RequestChatModelBeanBuildItem> requestChatModelBeanProducer, BuildProducer<RequestModerationModelBeanBuildItem> requestModerationModelBeanProducer, BuildProducer<DeclarativeAiServiceBuildItem> declarativeAiServiceProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> chatModelNames = new HashSet<String>();
        boolean needModerationModelBean = false;
        for (AnnotationInstance instance : index.getAnnotations(Langchain4jDotNames.REGISTER_AI_SERVICES)) {
            BuiltinScope declaredScope;
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo declarativeAiServiceClassInfo = instance.target().asClass();
            DotName chatLanguageModelSupplierClassDotName = null;
            AnnotationValue chatLanguageModelSupplierValue = instance.value("chatLanguageModelSupplier");
            if (chatLanguageModelSupplierValue != null) {
                chatLanguageModelSupplierClassDotName = chatLanguageModelSupplierValue.asClass().name();
                if (chatLanguageModelSupplierClassDotName.equals((Object)Langchain4jDotNames.BEAN_CHAT_MODEL_SUPPLIER)) {
                    chatLanguageModelSupplierClassDotName = null;
                } else {
                    this.validateSupplierAndRegisterForReflection(chatLanguageModelSupplierClassDotName, index, reflectiveClassProducer);
                }
            }
            String modeName = "<default>";
            if (chatLanguageModelSupplierClassDotName == null) {
                String modelNameValueStr;
                AnnotationValue modelNameValue = instance.value("modelName");
                if (modelNameValue != null && (modelNameValueStr = modelNameValue.asString()) != null && !modelNameValueStr.isEmpty()) {
                    modeName = modelNameValueStr;
                }
                chatModelNames.add(modeName);
            }
            List<DotName> toolDotNames = Collections.emptyList();
            AnnotationValue toolsInstance = instance.value("tools");
            if (toolsInstance != null) {
                toolDotNames = Arrays.stream(toolsInstance.asClassArray()).map(Type::name).collect(Collectors.toList());
            }
            DotName chatMemoryProviderSupplierClassDotName = Langchain4jDotNames.BEAN_CHAT_MEMORY_PROVIDER_SUPPLIER;
            AnnotationValue chatMemoryProviderSupplierValue = instance.value("chatMemoryProviderSupplier");
            if (chatMemoryProviderSupplierValue != null && !(chatMemoryProviderSupplierClassDotName = chatMemoryProviderSupplierValue.asClass().name()).equals((Object)Langchain4jDotNames.BEAN_CHAT_MEMORY_PROVIDER_SUPPLIER)) {
                this.validateSupplierAndRegisterForReflection(chatMemoryProviderSupplierClassDotName, index, reflectiveClassProducer);
            }
            DotName retrieverClassDotName = null;
            AnnotationValue retrieverValue = instance.value("retriever");
            if (retrieverValue != null && Langchain4jDotNames.NO_RETRIEVER.equals((Object)(retrieverClassDotName = retrieverValue.asClass().name()))) {
                retrieverClassDotName = null;
            }
            DotName auditServiceSupplierClassName = Langchain4jDotNames.BEAN_IF_EXISTS_AUDIT_SERVICE_SUPPLIER;
            AnnotationValue auditServiceSupplierValue = instance.value("auditServiceSupplier");
            if (auditServiceSupplierValue != null) {
                auditServiceSupplierClassName = auditServiceSupplierValue.asClass().name();
                this.validateSupplierAndRegisterForReflection(auditServiceSupplierClassName, index, reflectiveClassProducer);
            }
            DotName moderationModelSupplierClassName = null;
            AnnotationValue moderationModelSupplierValue = instance.value("moderationModelSupplier");
            if (moderationModelSupplierValue != null) {
                moderationModelSupplierClassName = moderationModelSupplierValue.asClass().name();
                if (Langchain4jDotNames.NO_MODERATION_MODEL_SUPPLIER.equals((Object)moderationModelSupplierClassName)) {
                    moderationModelSupplierClassName = null;
                } else if (Langchain4jDotNames.BEAN_MODERATION_MODEL_SUPPLIER.equals((Object)moderationModelSupplierClassName)) {
                    needModerationModelBean = true;
                } else {
                    this.validateSupplierAndRegisterForReflection(moderationModelSupplierClassName, index, reflectiveClassProducer);
                }
            }
            ScopeInfo cdiScope = (declaredScope = BuiltinScope.from((ClassInfo)declarativeAiServiceClassInfo)) != null ? declaredScope.getInfo() : BuiltinScope.REQUEST.getInfo();
            declarativeAiServiceProducer.produce((BuildItem)new DeclarativeAiServiceBuildItem(declarativeAiServiceClassInfo, chatLanguageModelSupplierClassDotName, toolDotNames, chatMemoryProviderSupplierClassDotName, retrieverClassDotName, auditServiceSupplierClassName, moderationModelSupplierClassName, cdiScope, modeName));
        }
        for (String chatModelName : chatModelNames) {
            requestChatModelBeanProducer.produce((BuildItem)new RequestChatModelBeanBuildItem(chatModelName));
        }
        if (needModerationModelBean) {
            requestModerationModelBeanProducer.produce((BuildItem)new RequestModerationModelBeanBuildItem());
        }
    }

    private void validateSupplierAndRegisterForReflection(DotName supplierDotName, IndexView index, BuildProducer<ReflectiveClassBuildItem> producer) {
        ClassInfo classInfo = index.getClassByName(supplierDotName);
        if (classInfo == null) {
            log.warn((Object)("'" + supplierDotName.toString() + "' cannot be indexed"));
            return;
        }
        if (!classInfo.hasNoArgsConstructor()) {
            throw new IllegalConfigurationException("Class '" + supplierDotName.toString() + "' which must contain a no-args constructor.");
        }
        producer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{supplierDotName.toString()}).constructors(true).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handleDeclarativeServices(AiServicesRecorder recorder, List<DeclarativeAiServiceBuildItem> declarativeAiServiceItems, List<SelectedChatModelProviderBuildItem> selectedChatModelProvider, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, BuildProducer<UnremovableBeanBuildItem> unremoveableProducer) {
        boolean needsChatModelBean = false;
        boolean needsChatMemoryProviderBean = false;
        boolean needsRetrieverBean = false;
        boolean needsAuditServiceBean = false;
        boolean needsModerationModelBean = false;
        HashSet<DotName> allToolNames = new HashSet<DotName>();
        for (DeclarativeAiServiceBuildItem bi : declarativeAiServiceItems) {
            ClassInfo declarativeAiServiceClassInfo = bi.getServiceClassInfo();
            String serviceClassName = declarativeAiServiceClassInfo.name().toString();
            String chatLanguageModelSupplierClassName = bi.getLanguageModelSupplierClassDotName() != null ? bi.getLanguageModelSupplierClassDotName().toString() : null;
            List toolClassNames = bi.getToolDotNames().stream().map(DotName::toString).collect(Collectors.toList());
            String chatMemoryProviderSupplierClassName = bi.getChatMemoryProviderSupplierClassDotName() != null ? bi.getChatMemoryProviderSupplierClassDotName().toString() : null;
            String retrieverClassName = bi.getRetrieverClassDotName() != null ? bi.getRetrieverClassDotName().toString() : null;
            String auditServiceClassSupplierName = bi.getAuditServiceClassSupplierDotName() != null ? bi.getAuditServiceClassSupplierDotName().toString() : null;
            String moderationModelSupplierClassName = bi.getModerationModelSupplierDotName() != null ? bi.getModerationModelSupplierDotName().toString() : null;
            String chatModelName = bi.getChatModelName();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusAiServiceContext.class).createWith(recorder.createDeclarativeAiService(new DeclarativeAiServiceCreateInfo(serviceClassName, chatLanguageModelSupplierClassName, toolClassNames, chatMemoryProviderSupplierClassName, retrieverClassName, auditServiceClassSupplierName, moderationModelSupplierClassName, chatModelName))).setRuntimeInit().addQualifier().annotation(Langchain4jDotNames.QUARKUS_AI_SERVICE_CONTEXT_QUALIFIER).addValue("value", (Object)serviceClassName).done()).scope(Dependent.class);
            if (chatLanguageModelSupplierClassName == null && !selectedChatModelProvider.isEmpty()) {
                if (NamedModelUtil.isDefault((String)chatModelName)) {
                    configurator.addInjectionPoint((Type)CHAT_MODEL_CLASS_TYPE, new AnnotationInstance[0]);
                } else {
                    configurator.addInjectionPoint((Type)CHAT_MODEL_CLASS_TYPE, new AnnotationInstance[]{AnnotationInstance.builder(ModelName.class).add("value", chatModelName).build()});
                }
                needsChatModelBean = true;
            }
            if (!toolClassNames.isEmpty()) {
                for (String toolClassName : toolClassNames) {
                    DotName dotName = DotName.createSimple((String)toolClassName);
                    configurator.addInjectionPoint((Type)ClassType.create((DotName)dotName), new AnnotationInstance[0]);
                    allToolNames.add(dotName);
                }
            }
            if (Langchain4jDotNames.BEAN_CHAT_MEMORY_PROVIDER_SUPPLIER.toString().equals(chatMemoryProviderSupplierClassName)) {
                configurator.addInjectionPoint((Type)ClassType.create((DotName)Langchain4jDotNames.CHAT_MEMORY_PROVIDER), new AnnotationInstance[0]);
                needsChatMemoryProviderBean = true;
            }
            if (retrieverClassName != null) {
                configurator.addInjectionPoint((Type)ClassType.create((String)retrieverClassName), new AnnotationInstance[0]);
                needsRetrieverBean = true;
            }
            if (Langchain4jDotNames.BEAN_IF_EXISTS_AUDIT_SERVICE_SUPPLIER.toString().equals(auditServiceClassSupplierName)) {
                configurator.addInjectionPoint((Type)ParameterizedType.create((DotName)CDI_INSTANCE, (Type[])new Type[]{ClassType.create((DotName)Langchain4jDotNames.AUDIT_SERVICE)}, null), new AnnotationInstance[0]);
                needsAuditServiceBean = true;
            }
            if (Langchain4jDotNames.BEAN_MODERATION_MODEL_SUPPLIER.toString().equals(moderationModelSupplierClassName)) {
                configurator.addInjectionPoint((Type)ClassType.create((DotName)Langchain4jDotNames.MODERATION_MODEL), new AnnotationInstance[0]);
                needsModerationModelBean = true;
            }
            syntheticBeanProducer.produce((BuildItem)configurator.done());
        }
        if (needsChatModelBean) {
            unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{Langchain4jDotNames.CHAT_MODEL}));
        }
        if (needsChatMemoryProviderBean) {
            unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{Langchain4jDotNames.CHAT_MEMORY_PROVIDER}));
        }
        if (needsRetrieverBean) {
            unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{Langchain4jDotNames.RETRIEVER}));
        }
        if (needsAuditServiceBean) {
            unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{Langchain4jDotNames.AUDIT_SERVICE}));
        }
        if (needsModerationModelBean) {
            unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{Langchain4jDotNames.MODERATION_MODEL}));
        }
        if (!allToolNames.isEmpty()) {
            unremoveableProducer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(allToolNames));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void handleAiServices(AiServicesRecorder recorder, CombinedIndexBuildItem indexBuildItem, List<DeclarativeAiServiceBuildItem> declarativeAiServiceItems, BuildProducer<GeneratedClassBuildItem> generatedClassProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<AiServicesMethodBuildItem> aiServicesMethodProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, Optional<MetricsCapabilityBuildItem> metricsCapability, Capabilities capabilities) {
        boolean addOpenTelemetrySpan;
        boolean addMicrometerMetrics;
        IndexView index = indexBuildItem.getIndex();
        ArrayList<AiServicesUseAnalyzer.Result.Entry> aiServicesAnalysisResults = new ArrayList<AiServicesUseAnalyzer.Result.Entry>();
        for (Object classInfo : index.getKnownUsers(Langchain4jDotNames.AI_SERVICES)) {
            String string = classInfo.name().toString();
            if (string.startsWith("io.quarkiverse.langchain4j") || string.startsWith("dev.langchain4j")) continue;
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(string.replace('.', '/') + ".class");
                try {
                    if (is == null) {
                        return;
                    }
                    ClassNode cn = new ClassNode(589824);
                    ClassReader cr = new ClassReader(is);
                    cr.accept((ClassVisitor)cn, 0);
                    for (MethodNode method : cn.methods) {
                        aiServicesAnalysisResults.addAll(AiServicesUseAnalyzer.analyze((ClassNode)cn, (MethodNode)method).entries);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Reading bytecode of class '" + string + "' failed", e2);
            }
            catch (AnalyzerException e3) {
                log.debug((Object)("Unable to analyze bytecode of class '" + string + "'"), (Throwable)e3);
            }
        }
        Map<String, Boolean> nameToUsed = aiServicesAnalysisResults.stream().collect(Collectors.toMap(e -> e.createdClassName, e -> e.chatMemoryProviderUsed, (u1, u2) -> u1 != false || u2 != false));
        for (Map.Entry entry : nameToUsed.entrySet()) {
            String className = (String)entry.getKey();
            ClassInfo classInfo = index.getClassByName(className);
            if (classInfo == null || classInfo.annotations(Langchain4jDotNames.MEMORY_ID).isEmpty() || ((Boolean)entry.getValue()).booleanValue()) continue;
            log.warn((Object)("Class '" + className + "' is used in AiServices and while it leverages @MemoryId, a ChatMemoryProvider has not been configured. This will likely result in an exception being thrown when the service is used."));
        }
        HashSet<String> detectedForCreate = new HashSet<String>(nameToUsed.keySet());
        AiServicesProcessor.addCreatedAware(index, detectedForCreate);
        this.addIfacesWithMessageAnns(index, detectedForCreate);
        Set set = declarativeAiServiceItems.stream().map(bi -> bi.getServiceClassInfo().name().toString()).collect(Collectors.toUnmodifiableSet());
        detectedForCreate.addAll(set);
        HashSet<ClassInfo> ifacesForCreate = new HashSet<ClassInfo>();
        for (String className : detectedForCreate) {
            ClassInfo classInfo = index.getClassByName(className);
            if (classInfo == null) {
                log.warn((Object)("'" + className + "' used for creating an AiService was not found in the Quarkus index. Attempting to create an AiService using this class will fail"));
                continue;
            }
            if (!classInfo.isInterface()) {
                log.warn((Object)("'" + className + "' used for creating an AiService is not an interface. Attempting to create an AiService using this class will fail"));
            }
            ifacesForCreate.add(classInfo);
        }
        boolean bl = addMicrometerMetrics = metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        if (addMicrometerMetrics) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MetricsTimedWrapper.class).build());
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MetricsCountedWrapper.class).build());
        }
        if (addOpenTelemetrySpan = capabilities.isPresent("io.quarkus.opentelemetry.tracer")) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(SpanWrapper.class).build());
        }
        HashMap<String, AiServiceClassCreateInfo> perClassMetadata = new HashMap<String, AiServiceClassCreateInfo>();
        if (!ifacesForCreate.isEmpty()) {
            GeneratedClassGizmoAdaptor generatedClassOutput = new GeneratedClassGizmoAdaptor(generatedClassProducer, true);
            GeneratedBeanGizmoAdaptor generatedBeanOutput = new GeneratedBeanGizmoAdaptor(generatedBeanProducer);
            for (ClassInfo iface : ifacesForCreate) {
                HashSet allMethods = new HashSet(iface.methods());
                JandexUtil.getAllSuperinterfaces(iface, index).forEach(ci -> allMethods.addAll(ci.methods()));
                ArrayList<MethodInfo> methodsToImplement = new ArrayList<MethodInfo>();
                HashMap<String, AiServiceMethodCreateInfo> perMethodMetadata = new HashMap<String, AiServiceMethodCreateInfo>();
                for (MethodInfo method : allMethods) {
                    short modifiers = method.flags();
                    if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || JandexUtil.isDefault(modifiers)) continue;
                    methodsToImplement.add(method);
                }
                String ifaceName = iface.name().toString();
                String implClassName = ifaceName + "$$QuarkusImpl";
                boolean isRegisteredService = set.contains(ifaceName);
                ClassCreator.Builder classCreatorBuilder = ClassCreator.builder().classOutput((ClassOutput)(isRegisteredService ? generatedBeanOutput : generatedClassOutput)).className(implClassName).interfaces(new String[]{ifaceName, ChatMemoryRemovable.class.getName()});
                if (isRegisteredService) {
                    classCreatorBuilder.interfaces(new Class[]{AutoCloseable.class});
                }
                try (ClassCreator classCreator = classCreatorBuilder.build();){
                    ResultHandle contextHandle;
                    MethodCreator mc;
                    if (isRegisteredService) {
                        ScopeInfo scopeInfo = declarativeAiServiceItems.stream().filter(bi -> bi.getServiceClassInfo().equals(iface)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to determine the CDI scope of " + iface)).getCdiScope();
                        classCreator.addAnnotation(scopeInfo.getDotName().toString());
                    }
                    FieldDescriptor contextField = ((FieldCreator)classCreator.getFieldCreator("context", QuarkusAiServiceContext.class).setModifiers(18)).getFieldDescriptor();
                    for (MethodInfo methodInfo : methodsToImplement) {
                        String methodId = this.createMethodId(methodInfo);
                        perMethodMetadata.put(methodId, this.gatherMethodMetadata(methodInfo, addMicrometerMetrics, addOpenTelemetrySpan));
                        MethodCreator ctor = classCreator.getMethodCreator("<init>", (Object)"V", new Object[]{QuarkusAiServiceContext.class});
                        ctor.setModifiers(1);
                        ctor.addAnnotation(Inject.class);
                        ctor.getParameterAnnotations(0).addAnnotation(Langchain4jDotNames.QUARKUS_AI_SERVICE_CONTEXT_QUALIFIER.toString()).add("value", (Object)ifaceName);
                        ctor.invokeSpecialMethod(OBJECT_CONSTRUCTOR, ctor.getThis(), new ResultHandle[0]);
                        ctor.writeInstanceField(contextField, ctor.getThis(), ctor.getMethodParam(0));
                        ctor.returnValue(null);
                        MethodCreator noArgsCtor = classCreator.getMethodCreator("<init>", "V", new String[0]);
                        noArgsCtor.setModifiers(1);
                        noArgsCtor.invokeSpecialMethod(OBJECT_CONSTRUCTOR, noArgsCtor.getThis(), new ResultHandle[0]);
                        noArgsCtor.writeInstanceField(contextField, noArgsCtor.getThis(), noArgsCtor.loadNull());
                        noArgsCtor.returnValue(null);
                        MethodCreator mc2 = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)methodInfo));
                        for (AnnotationInstance annotationInstance : methodInfo.declaredAnnotations()) {
                            if (!annotationInstance.name().toString().startsWith("org.eclipse.microprofile.faulttolerance") && !annotationInstance.name().toString().startsWith("io.smallrye.faulttolerance.api")) continue;
                            mc2.addAnnotation(annotationInstance);
                        }
                        ResultHandle contextHandle2 = mc2.readInstanceField(contextField, mc2.getThis());
                        ResultHandle methodCreateInfoHandle = mc2.invokeStaticMethod(RECORDER_METHOD_CREATE_INFO, new ResultHandle[]{mc2.load(ifaceName), mc2.load(methodId)});
                        ResultHandle paramsHandle = mc2.newArray(Object.class, methodInfo.parametersCount());
                        for (int i = 0; i < methodInfo.parametersCount(); ++i) {
                            mc2.writeArrayValue(paramsHandle, i, mc2.getMethodParam(i));
                        }
                        ResultHandle supportHandle = this.getFromCDI(mc2, AiServiceMethodImplementationSupport.class.getName());
                        ResultHandle inputHandle = mc2.newInstance(MethodDescriptor.ofConstructor(AiServiceMethodImplementationSupport.Input.class, (Class[])new Class[]{QuarkusAiServiceContext.class, AiServiceMethodCreateInfo.class, Object[].class}), new ResultHandle[]{contextHandle2, methodCreateInfoHandle, paramsHandle});
                        ResultHandle resultHandle = mc2.invokeVirtualMethod(SUPPORT_IMPLEMENT, supportHandle, new ResultHandle[]{inputHandle});
                        mc2.returnValue(resultHandle);
                        aiServicesMethodProducer.produce((BuildItem)new AiServicesMethodBuildItem(methodInfo));
                    }
                    if (isRegisteredService) {
                        mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"close", Void.TYPE, (Object[])new Object[0]));
                        mc.addAnnotation(PreDestroy.class);
                        contextHandle = mc.readInstanceField(contextField, mc.getThis());
                        mc.invokeVirtualMethod(QUARKUS_AI_SERVICES_CONTEXT_CLOSE, contextHandle, new ResultHandle[0]);
                        mc.returnVoid();
                    }
                    mc = classCreator.getMethodCreator(MethodDescriptor.ofMethod((Object)implClassName, (String)"remove", Void.TYPE, (Object[])new Object[]{Object[].class}));
                    contextHandle = mc.readInstanceField(contextField, mc.getThis());
                    mc.invokeVirtualMethod(QUARKUS_AI_SERVICES_CONTEXT_REMOVE_CHAT_MEMORY_IDS, contextHandle, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnVoid();
                }
                perClassMetadata.put(ifaceName, new AiServiceClassCreateInfo(perMethodMetadata, implClassName));
                reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{implClassName}).build());
            }
        }
        recorder.setMetadata(perClassMetadata);
    }

    private ResultHandle getFromCDI(MethodCreator mc, String className) {
        ResultHandle containerHandle = mc.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{mc.loadClassFromTCCL(className), mc.newArray(Annotation.class, 0)});
        return mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
    }

    private String createMethodId(MethodInfo methodInfo) {
        return methodInfo.name() + "(" + Arrays.toString(methodInfo.parameters().stream().map(mp -> mp.type().name().toString()).toArray()) + ")";
    }

    private void addIfacesWithMessageAnns(IndexView index, Set<String> detectedForCreate) {
        List<DotName> annotations = List.of(Langchain4jDotNames.SYSTEM_MESSAGE, Langchain4jDotNames.USER_MESSAGE, Langchain4jDotNames.MODERATE);
        for (DotName annotation : annotations) {
            Collection instances = index.getAnnotations(annotation);
            for (AnnotationInstance instance : instances) {
                ClassInfo declaringClass;
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD || !(declaringClass = instance.target().asMethod().declaringClass()).isInterface()) continue;
                detectedForCreate.add(declaringClass.name().toString());
            }
        }
    }

    private static void addCreatedAware(IndexView index, Set<String> detectedForCreate) {
        Collection instances = index.getAnnotations(Langchain4jDotNames.CREATED_AWARE);
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            detectedForCreate.add(instance.target().asClass().name().toString());
        }
    }

    private AiServiceMethodCreateInfo gatherMethodMetadata(MethodInfo method, boolean addMicrometerMetrics, boolean addOpenTelemetrySpans) {
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw IllegalConfigurationException.illegalConfiguration((String)"Return type of method '%s' cannot be void", (Object[])new Object[]{method});
        }
        boolean requiresModeration = method.hasAnnotation(Langchain4jDotNames.MODERATE);
        List params = method.parameters();
        List<TemplateParameterInfo> templateParams = this.gatherTemplateParamInfo(params);
        Optional<AiServiceMethodCreateInfo.TemplateInfo> systemMessageInfo = this.gatherSystemMessageInfo(method, templateParams);
        Class<?> returnType = JandexUtil.load(method.returnType(), Thread.currentThread().getContextClassLoader());
        AiServiceMethodCreateInfo.UserMessageInfo userMessageInfo = this.gatherUserMessageInfo(method, templateParams, returnType);
        Optional<Integer> memoryIdParamPosition = this.gatherMemoryIdParamName(method);
        Optional<AiServiceMethodCreateInfo.MetricsTimedInfo> metricsTimedInfo = this.gatherMetricsTimedInfo(method, addMicrometerMetrics);
        Optional<AiServiceMethodCreateInfo.MetricsCountedInfo> metricsCountedInfo = this.gatherMetricsCountedInfo(method, addMicrometerMetrics);
        Optional<AiServiceMethodCreateInfo.SpanInfo> spanInfo = this.gatherSpanInfo(method, addOpenTelemetrySpans);
        return new AiServiceMethodCreateInfo(method.declaringClass().name().toString(), method.name(), systemMessageInfo, userMessageInfo, memoryIdParamPosition, requiresModeration, returnType, metricsTimedInfo, metricsCountedInfo, spanInfo);
    }

    private List<TemplateParameterInfo> gatherTemplateParamInfo(List<MethodParameterInfo> params) {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TemplateParameterInfo> templateParams = new ArrayList<TemplateParameterInfo>();
        for (MethodParameterInfo param : params) {
            AnnotationValue value;
            if (this.effectiveParamAnnotations(param).isEmpty()) {
                templateParams.add(new TemplateParameterInfo(param.position(), param.name()));
                continue;
            }
            AnnotationInstance vInstance = param.annotation(V);
            if (vInstance == null || (value = vInstance.value()) == null) continue;
            templateParams.add(new TemplateParameterInfo(param.position(), value.asString()));
        }
        if (templateParams.size() == 1 && params.size() == 1) {
            templateParams.add(new TemplateParameterInfo(0, "it"));
        }
        return templateParams;
    }

    private List<AnnotationInstance> effectiveParamAnnotations(MethodParameterInfo param) {
        return param.annotations().stream().filter(ai -> {
            String name = ai.name().toString();
            if (name.startsWith("kotlin") || name.startsWith("jakarta.validation.constraints")) {
                return false;
            }
            if (name.endsWith("NotNull")) {
                return false;
            }
            return !name.startsWith("io.opentelemetry");
        }).collect(Collectors.toList());
    }

    private Optional<AiServiceMethodCreateInfo.TemplateInfo> gatherSystemMessageInfo(MethodInfo method, List<TemplateParameterInfo> templateParams) {
        AnnotationInstance instance = method.annotation(Langchain4jDotNames.SYSTEM_MESSAGE);
        if (instance != null) {
            String systemMessageTemplate = "";
            AnnotationValue delimiterValue = instance.value("delimiter");
            String delimiter = delimiterValue != null ? delimiterValue.asString() : DEFAULT_DELIMITER;
            AnnotationValue value = instance.value();
            if (value != null) {
                systemMessageTemplate = String.join((CharSequence)delimiter, value.asStringArray());
            }
            if (systemMessageTemplate.isEmpty()) {
                throw ExceptionUtil.illegalConfigurationForMethod("@SystemMessage's template parameter cannot be empty", method);
            }
            return Optional.of(new AiServiceMethodCreateInfo.TemplateInfo(systemMessageTemplate, TemplateParameterInfo.toNameToArgsPositionMap(templateParams)));
        }
        return Optional.empty();
    }

    private Optional<Integer> gatherMemoryIdParamName(MethodInfo method) {
        return method.annotations(Langchain4jDotNames.MEMORY_ID).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
    }

    private AiServiceMethodCreateInfo.UserMessageInfo gatherUserMessageInfo(MethodInfo method, List<TemplateParameterInfo> templateParams, Class<?> returnType) {
        String outputFormatInstructions = ServiceOutputParser.outputFormatInstructions(returnType);
        Optional<Integer> userNameParamName = method.annotations(Langchain4jDotNames.USER_NAME).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).map(METHOD_PARAMETER_POSITION_FUNCTION).findFirst();
        AnnotationInstance userMessageInstance = method.declaredAnnotation(Langchain4jDotNames.USER_MESSAGE);
        if (userMessageInstance != null) {
            AnnotationValue delimiterValue = userMessageInstance.value("delimiter");
            String delimiter = delimiterValue != null ? delimiterValue.asString() : DEFAULT_DELIMITER;
            String userMessageTemplate = String.join((CharSequence)delimiter, userMessageInstance.value().asStringArray());
            if (userMessageTemplate.contains("{{it}}") && method.parametersCount() != 1) {
                throw ExceptionUtil.illegalConfigurationForMethod("Error: The {{it}} placeholder is present but the method does not have exactly one parameter. Please ensure that methods using the {{it}} placeholder have exactly one parameter", method);
            }
            return AiServiceMethodCreateInfo.UserMessageInfo.fromTemplate((AiServiceMethodCreateInfo.TemplateInfo)new AiServiceMethodCreateInfo.TemplateInfo(userMessageTemplate, TemplateParameterInfo.toNameToArgsPositionMap(templateParams)), userNameParamName, (String)outputFormatInstructions);
        }
        Optional<AnnotationInstance> userMessageOnMethodParam = method.annotations(Langchain4jDotNames.USER_MESSAGE).stream().filter(IS_METHOD_PARAMETER_ANNOTATION).findFirst();
        if (userMessageOnMethodParam.isPresent()) {
            return AiServiceMethodCreateInfo.UserMessageInfo.fromMethodParam((int)userMessageOnMethodParam.get().target().asMethodParameter().position(), userNameParamName, (String)outputFormatInstructions);
        }
        if (method.parametersCount() == 0) {
            throw ExceptionUtil.illegalConfigurationForMethod("Method should have at least one argument", method);
        }
        if (method.parametersCount() == 1) {
            return AiServiceMethodCreateInfo.UserMessageInfo.fromMethodParam((int)0, userNameParamName, (String)outputFormatInstructions);
        }
        throw ExceptionUtil.illegalConfigurationForMethod("For methods with multiple parameters, each parameter must be annotated with @V (or match an template parameter by name), @UserMessage, @UserName or @MemoryId", method);
    }

    private Optional<AiServiceMethodCreateInfo.MetricsTimedInfo> gatherMetricsTimedInfo(MethodInfo method, boolean addMicrometerMetrics) {
        AnnotationValue descriptionValue;
        AnnotationValue histogramValue;
        AnnotationValue percentilesValue;
        String nameStr;
        if (!addMicrometerMetrics) {
            return Optional.empty();
        }
        String name = METRICS_DEFAULT_NAME;
        List<String> tags = this.defaultMetricsTags(method);
        AnnotationInstance timedInstance = method.annotation(MICROMETER_TIMED);
        if (timedInstance == null) {
            timedInstance = method.declaringClass().declaredAnnotation(MICROMETER_TIMED);
        }
        if (timedInstance == null) {
            return Optional.of(new AiServiceMethodCreateInfo.MetricsTimedInfo.Builder(name).setExtraTags(tags.toArray(EMPTY_STRING_ARRAY)).build());
        }
        AnnotationValue nameValue = timedInstance.value();
        if (nameValue != null && (nameStr = nameValue.asString()) != null && !nameStr.isEmpty()) {
            name = nameStr;
        }
        AiServiceMethodCreateInfo.MetricsTimedInfo.Builder builder = new AiServiceMethodCreateInfo.MetricsTimedInfo.Builder(name);
        AnnotationValue extraTagsValue = timedInstance.value("extraTags");
        if (extraTagsValue != null) {
            tags.addAll(Arrays.asList(extraTagsValue.asStringArray()));
        }
        builder.setExtraTags(tags.toArray(EMPTY_STRING_ARRAY));
        AnnotationValue longTaskValue = timedInstance.value("longTask");
        if (longTaskValue != null) {
            builder.setLongTask(longTaskValue.asBoolean());
        }
        if ((percentilesValue = timedInstance.value("percentiles")) != null) {
            builder.setPercentiles(percentilesValue.asDoubleArray());
        }
        if ((histogramValue = timedInstance.value("histogram")) != null) {
            builder.setHistogram(histogramValue.asBoolean());
        }
        if ((descriptionValue = timedInstance.value("description")) != null) {
            builder.setDescription(descriptionValue.asString());
        }
        return Optional.of(builder.build());
    }

    private Optional<AiServiceMethodCreateInfo.MetricsCountedInfo> gatherMetricsCountedInfo(MethodInfo method, boolean addMicrometerMetrics) {
        AnnotationValue descriptionValue;
        String nameStr;
        if (!addMicrometerMetrics) {
            return Optional.empty();
        }
        String name = METRICS_DEFAULT_NAME;
        List<String> tags = this.defaultMetricsTags(method);
        AnnotationInstance timedInstance = method.annotation(MICROMETER_COUNTED);
        if (timedInstance == null) {
            timedInstance = method.declaringClass().declaredAnnotation(MICROMETER_COUNTED);
        }
        if (timedInstance == null) {
            return Optional.of(new AiServiceMethodCreateInfo.MetricsCountedInfo.Builder(name).setExtraTags(tags.toArray(EMPTY_STRING_ARRAY)).build());
        }
        AnnotationValue nameValue = timedInstance.value();
        if (nameValue != null && (nameStr = nameValue.asString()) != null && !nameStr.isEmpty()) {
            name = nameStr;
        }
        AiServiceMethodCreateInfo.MetricsCountedInfo.Builder builder = new AiServiceMethodCreateInfo.MetricsCountedInfo.Builder(name);
        AnnotationValue extraTagsValue = timedInstance.value("extraTags");
        if (extraTagsValue != null) {
            tags.addAll(Arrays.asList(extraTagsValue.asStringArray()));
        }
        builder.setExtraTags(tags.toArray(EMPTY_STRING_ARRAY));
        AnnotationValue recordFailuresOnlyValue = timedInstance.value("recordFailuresOnly");
        if (recordFailuresOnlyValue != null) {
            builder.setRecordFailuresOnly(recordFailuresOnlyValue.asBoolean());
        }
        if ((descriptionValue = timedInstance.value("description")) != null) {
            builder.setDescription(descriptionValue.asString());
        }
        return Optional.of(builder.build());
    }

    private List<String> defaultMetricsTags(MethodInfo method) {
        ArrayList<String> tags = new ArrayList<String>(4);
        tags.add("aiservice");
        tags.add(method.declaringClass().name().withoutPackagePrefix());
        tags.add("method");
        tags.add(method.name());
        return tags;
    }

    private Optional<AiServiceMethodCreateInfo.SpanInfo> gatherSpanInfo(MethodInfo method, boolean addOpenTelemetrySpans) {
        if (!addOpenTelemetrySpans) {
            return Optional.empty();
        }
        String name = this.defaultAiServiceSpanName(method);
        return Optional.of(new AiServiceMethodCreateInfo.SpanInfo(name));
    }

    private String defaultAiServiceSpanName(MethodInfo method) {
        return "langchain4j.aiservices." + method.declaringClass().name().withoutPackagePrefix() + "." + method.name();
    }

    public static final class AiServicesMethodBuildItem
    extends MultiBuildItem {
        private final MethodInfo methodInfo;

        public AiServicesMethodBuildItem(MethodInfo methodInfo) {
            this.methodInfo = methodInfo;
        }

        public MethodInfo getMethodInfo() {
            return this.methodInfo;
        }
    }

    private static class TemplateParameterInfo {
        private final int position;
        private final String name;

        public TemplateParameterInfo(int position, String name) {
            this.position = position;
            this.name = name;
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        static Map<String, Integer> toNameToArgsPositionMap(List<TemplateParameterInfo> list) {
            return list.stream().collect(Collectors.toMap(TemplateParameterInfo::getName, TemplateParameterInfo::getPosition));
        }
    }
}

