/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.chroma.deployment;

import io.quarkiverse.langchain4j.chroma.deployment.ChromaBuildConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class ChromaDevServicesProcessor {
    private static final Logger log = Logger.getLogger(ChromaDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-chroma";
    private static final String IMAGE_NAME = "ghcr.io/chroma-core/chroma";
    private static final int CHROMA_PORT = 8000;
    private static final ContainerLocator containerLocator = new ContainerLocator("quarkus-dev-service-chroma", 8000);
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile ChromaDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startChromaDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, ChromaBuildConfig chromaBuildConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        ChromaDevServiceCfg configuration = this.getConfiguration(chromaBuildConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.shutdownContainer();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Chroma Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newDevService = this.startContainer(dockerStatusBuildItem, configuration, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (newDevService != null) {
                devService = newDevService;
                Map config = devService.getConfig();
                if (devService.isOwner()) {
                    log.info((Object)"Dev Services for Chroma started.");
                }
            }
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownContainer();
                    log.info((Object)"Dev Services for Chroma shut down.");
                }
                first = true;
                devService = null;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = configuration;
        return devService.toBuildItem();
    }

    private void shutdownContainer() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Chroma server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, ChromaDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for Chroma, as it has been disabled in the config.");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the Chroma server location.");
            return null;
        }
        ConfiguredChromaContainer container = new ConfiguredChromaContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor(IMAGE_NAME), config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultChromaSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((ConfiguredChromaContainer)container).withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.start();
            return this.getRunningDevService(container.getContainerId(), () -> ((ConfiguredChromaContainer)container).close(), container.getHost(), container.getPort());
        };
        return containerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultChromaSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningDevService(String containerId, Closeable closeable, String host, int port) {
        Map<String, CallSite> configMap = Map.of("quarkus.langchain4j.chroma.url", "http://" + host + ":" + port);
        return new DevServicesResultBuildItem.RunningDevService("langchain4j-chroma", containerId, closeable, configMap);
    }

    private ChromaDevServiceCfg getConfiguration(ChromaBuildConfig cfg) {
        return new ChromaDevServiceCfg(cfg.devservices());
    }

    static {
        first = true;
    }

    private static final class ChromaDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final OptionalInt fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final Map<String, String> containerEnv;

        public ChromaDevServiceCfg(ChromaBuildConfig.ChromaDevServicesBuildTimeConfig devServicesConfig) {
            this.devServicesEnabled = devServicesConfig.enabled();
            this.imageName = devServicesConfig.imageName();
            this.fixedExposedPort = devServicesConfig.port();
            this.shared = devServicesConfig.shared();
            this.serviceName = devServicesConfig.serviceName();
            this.containerEnv = devServicesConfig.containerEnv();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChromaDevServiceCfg that = (ChromaDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && Objects.equals(this.containerEnv, that.containerEnv);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.containerEnv);
        }
    }

    private static class ConfiguredChromaContainer
    extends GenericContainer<ConfiguredChromaContainer> {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public ConfiguredChromaContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(ChromaDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"chroma");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8000);
            } else {
                this.addExposedPort(8000);
            }
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 8000;
            }
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getFirstMappedPort();
        }

        public String getHost() {
            return this.useSharedNetwork ? this.hostName : super.getHost();
        }
    }
}

