/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.bam.deployment;

import io.quarkiverse.langchain4j.bam.deployment.Langchain4jBamBuildConfig;
import io.quarkiverse.langchain4j.bam.runtime.BamRecorder;
import io.quarkiverse.langchain4j.bam.runtime.config.Langchain4jBamConfig;
import io.quarkiverse.langchain4j.deployment.Langchain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import org.jboss.jandex.DotName;

public class BamProcessor {
    private static final String FEATURE = "langchain4j-bam";
    private static final String PROVIDER = "bam";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, Langchain4jBamBuildConfig config) {
        if (config.chatModel().enabled().isEmpty() || config.chatModel().enabled().get().booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(BamRecorder recorder, Optional<SelectedChatModelProviderBuildItem> selectedChatItem, Langchain4jBamConfig config, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        if (selectedChatItem.isPresent() && PROVIDER.equals(selectedChatItem.get().getProvider())) {
            beanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)Langchain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.chatModel(config)).done());
        }
    }
}

