/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.bam.deployment;

import io.quarkiverse.langchain4j.ModelName;
import io.quarkiverse.langchain4j.bam.deployment.LangChain4jBamBuildConfig;
import io.quarkiverse.langchain4j.bam.runtime.BamRecorder;
import io.quarkiverse.langchain4j.bam.runtime.config.LangChain4jBamConfig;
import io.quarkiverse.langchain4j.deployment.LangChain4jDotNames;
import io.quarkiverse.langchain4j.deployment.items.ChatModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.EmbeddingModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.ModerationModelProviderCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedChatModelProviderBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedEmbeddingModelCandidateBuildItem;
import io.quarkiverse.langchain4j.deployment.items.SelectedModerationModelProviderBuildItem;
import io.quarkiverse.langchain4j.runtime.NamedModelUtil;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class BamProcessor {
    private static final String FEATURE = "langchain4j-bam";
    private static final String PROVIDER = "bam";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void providerCandidates(BuildProducer<ChatModelProviderCandidateBuildItem> chatProducer, BuildProducer<EmbeddingModelProviderCandidateBuildItem> embeddingProducer, BuildProducer<ModerationModelProviderCandidateBuildItem> moderationProducer, LangChain4jBamBuildConfig config) {
        if (config.chatModel().enabled().isEmpty() || config.chatModel().enabled().get().booleanValue()) {
            chatProducer.produce((BuildItem)new ChatModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.embeddingModel().enabled().isEmpty() || config.embeddingModel().enabled().get().booleanValue()) {
            embeddingProducer.produce((BuildItem)new EmbeddingModelProviderCandidateBuildItem(PROVIDER));
        }
        if (config.moderationModel().enabled().isEmpty() || config.moderationModel().enabled().get().booleanValue()) {
            moderationProducer.produce((BuildItem)new ModerationModelProviderCandidateBuildItem(PROVIDER));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateBeans(BamRecorder recorder, List<SelectedChatModelProviderBuildItem> selectedChatItem, List<SelectedEmbeddingModelCandidateBuildItem> selectedEmbedding, List<SelectedModerationModelProviderBuildItem> selectedModeration, LangChain4jBamConfig config, BuildProducer<SyntheticBeanBuildItem> beanProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator builder;
        String modelName;
        for (SelectedChatModelProviderBuildItem selectedChatModelProviderBuildItem : selectedChatItem) {
            if (!PROVIDER.equals(selectedChatModelProviderBuildItem.getProvider())) continue;
            modelName = selectedChatModelProviderBuildItem.getModelName();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator chatBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.chatModel(config, modelName));
            this.addQualifierIfNecessary(chatBuilder, modelName);
            beanProducer.produce((BuildItem)chatBuilder.done());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator streamingBuilder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.STREAMING_CHAT_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.streamingChatModel(config, modelName));
            this.addQualifierIfNecessary(streamingBuilder, modelName);
            beanProducer.produce((BuildItem)streamingBuilder.done());
        }
        for (SelectedEmbeddingModelCandidateBuildItem selectedEmbeddingModelCandidateBuildItem : selectedEmbedding) {
            if (!PROVIDER.equals(selectedEmbeddingModelCandidateBuildItem.getProvider())) continue;
            modelName = selectedEmbeddingModelCandidateBuildItem.getModelName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.EMBEDDING_MODEL).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).supplier(recorder.embeddingModel(config, modelName));
            this.addQualifierIfNecessary(builder, modelName);
            beanProducer.produce((BuildItem)builder.done());
        }
        for (SelectedModerationModelProviderBuildItem selectedModerationModelProviderBuildItem : selectedModeration) {
            if (!PROVIDER.equals(selectedModerationModelProviderBuildItem.getProvider())) continue;
            modelName = selectedModerationModelProviderBuildItem.getModelName();
            builder = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)LangChain4jDotNames.MODERATION_MODEL).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).supplier(recorder.moderationModel(config, modelName));
            this.addQualifierIfNecessary(builder, modelName);
            beanProducer.produce((BuildItem)builder.done());
        }
    }

    private void addQualifierIfNecessary(SyntheticBeanBuildItem.ExtendedBeanConfigurator builder, String modelName) {
        if (!NamedModelUtil.isDefault((String)modelName)) {
            builder.addQualifier(AnnotationInstance.builder(ModelName.class).add("value", modelName).build());
        }
    }
}

