/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.azure.openai.runtime;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.DisabledChatLanguageModel;
import dev.langchain4j.model.chat.DisabledStreamingChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.image.DisabledImageModel;
import dev.langchain4j.model.image.ImageModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiChatModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiEmbeddingModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiImageModel;
import io.quarkiverse.langchain4j.azure.openai.AzureOpenAiStreamingChatModel;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.ImageModelConfig;
import io.quarkiverse.langchain4j.azure.openai.runtime.config.LangChain4jAzureOpenAiConfig;
import io.quarkiverse.langchain4j.openai.QuarkusOpenAiClient;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class AzureOpenAiRecorder {
    static final String AZURE_ENDPOINT_URL_PATTERN = "https://%s.openai.azure.com/openai/deployments/%s";
    public static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];

    public Supplier<ChatLanguageModel> chatModel(LangChain4jAzureOpenAiConfig runtimeConfig, String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig(runtimeConfig, configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = azureAiConfig.chatModel();
            String apiKey = azureAiConfig.apiKey().orElse(null);
            String adToken = azureAiConfig.adToken().orElse(null);
            this.throwIfApiKeysNotConfigured(apiKey, adToken, configName);
            final AzureOpenAiChatModel.Builder builder = AzureOpenAiChatModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.CHAT)).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).apiKey(apiKey).adToken(adToken).apiVersion(azureAiConfig.apiVersion()).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(azureAiConfig.maxRetries()).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false)).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat(chatModelConfig.responseFormat().orElse(null));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Supplier<ChatLanguageModel>(){

                @Override
                public ChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ChatLanguageModel>(){

            @Override
            public ChatLanguageModel get() {
                return new DisabledChatLanguageModel();
            }
        };
    }

    public Supplier<StreamingChatLanguageModel> streamingChatModel(LangChain4jAzureOpenAiConfig runtimeConfig, String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig(runtimeConfig, configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            ChatModelConfig chatModelConfig = azureAiConfig.chatModel();
            String apiKey = azureAiConfig.apiKey().orElse(null);
            String adToken = azureAiConfig.adToken().orElse(null);
            this.throwIfApiKeysNotConfigured(apiKey, adToken, configName);
            final AzureOpenAiStreamingChatModel.Builder builder = AzureOpenAiStreamingChatModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.CHAT)).apiKey(apiKey).adToken(adToken).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).apiVersion(azureAiConfig.apiVersion()).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).logRequests(chatModelConfig.logRequests().orElse(false)).logResponses(chatModelConfig.logResponses().orElse(false)).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).presencePenalty(chatModelConfig.presencePenalty()).frequencyPenalty(chatModelConfig.frequencyPenalty()).responseFormat(chatModelConfig.responseFormat().orElse(null));
            if (chatModelConfig.maxTokens().isPresent()) {
                builder.maxTokens(chatModelConfig.maxTokens().get());
            }
            return new Supplier<StreamingChatLanguageModel>(){

                @Override
                public StreamingChatLanguageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<StreamingChatLanguageModel>(){

            @Override
            public StreamingChatLanguageModel get() {
                return new DisabledStreamingChatLanguageModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(LangChain4jAzureOpenAiConfig runtimeConfig, String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig(runtimeConfig, configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            EmbeddingModelConfig embeddingModelConfig = azureAiConfig.embeddingModel();
            String apiKey = azureAiConfig.apiKey().orElse(null);
            String adToken = azureAiConfig.adToken().orElse(null);
            if (apiKey == null && adToken == null) {
                throw new ConfigValidationException(this.createKeyMisconfigurationProblem(configName));
            }
            final AzureOpenAiEmbeddingModel.Builder builder = AzureOpenAiEmbeddingModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.EMBEDDING)).apiKey(apiKey).adToken(adToken).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).apiVersion(azureAiConfig.apiVersion()).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(azureAiConfig.maxRetries()).logRequests(embeddingModelConfig.logRequests().orElse(false)).logResponses(embeddingModelConfig.logResponses().orElse(false));
            return new Supplier<EmbeddingModel>(){

                @Override
                public EmbeddingModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ImageModel> imageModel(LangChain4jAzureOpenAiConfig runtimeConfig, String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = this.correspondingAzureOpenAiConfig(runtimeConfig, configName);
        if (azureAiConfig.enableIntegration().booleanValue()) {
            String apiKey = azureAiConfig.apiKey().orElse(null);
            String adToken = azureAiConfig.adToken().orElse(null);
            this.throwIfApiKeysNotConfigured(apiKey, adToken, configName);
            ImageModelConfig imageModelConfig = azureAiConfig.imageModel();
            final AzureOpenAiImageModel.Builder builder = AzureOpenAiImageModel.builder().endpoint(AzureOpenAiRecorder.getEndpoint(azureAiConfig, configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType.IMAGE)).apiKey(apiKey).adToken(adToken).apiVersion(azureAiConfig.apiVersion()).timeout(azureAiConfig.timeout().orElse(Duration.ofSeconds(10L))).maxRetries(azureAiConfig.maxRetries()).logRequests(imageModelConfig.logRequests().orElse(false)).logResponses(imageModelConfig.logResponses().orElse(false)).modelName(imageModelConfig.modelName()).configName(NamedConfigUtil.isDefault((String)configName) ? null : configName).size(imageModelConfig.size()).quality(imageModelConfig.quality()).style(imageModelConfig.style()).responseFormat(imageModelConfig.responseFormat()).user(imageModelConfig.user());
            Optional<Path> persistDirectory = Optional.empty();
            if (imageModelConfig.persist().isPresent()) {
                if (imageModelConfig.persist().get().booleanValue()) {
                    persistDirectory = imageModelConfig.persistDirectory().or((Supplier<Optional<Path>>)new Supplier<Optional<? extends Path>>(){

                        @Override
                        public Optional<? extends Path> get() {
                            return Optional.of(Paths.get(System.getProperty("java.io.tmpdir"), "dall-e-images"));
                        }
                    });
                }
            } else if (imageModelConfig.persistDirectory().isPresent()) {
                persistDirectory = imageModelConfig.persistDirectory();
            }
            builder.persistDirectory(persistDirectory);
            return new Supplier<ImageModel>(){

                @Override
                public ImageModel get() {
                    return builder.build();
                }
            };
        }
        return new Supplier<ImageModel>(){

            @Override
            public ImageModel get() {
                return new DisabledImageModel();
            }
        };
    }

    static String getEndpoint(LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig, String configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType type) {
        Optional<String> endpoint = azureAiConfig.endPointFor(type);
        return endpoint.isPresent() && !endpoint.get().trim().isBlank() ? endpoint.get() : AzureOpenAiRecorder.constructEndpointFromConfig(azureAiConfig, configName, type);
    }

    private static String constructEndpointFromConfig(LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig, String configName, LangChain4jAzureOpenAiConfig.AzureAiConfig.EndpointType type) {
        Optional<String> resourceName = azureAiConfig.resourceNameFor(type);
        Optional<String> deploymentName = azureAiConfig.deploymentNameFor(type);
        if (resourceName.isEmpty() || deploymentName.isEmpty()) {
            ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
            if (resourceName.isEmpty()) {
                configProblems.add(AzureOpenAiRecorder.createConfigProblem("resource-name", configName));
            }
            if (deploymentName.isEmpty()) {
                configProblems.add(AzureOpenAiRecorder.createConfigProblem("deployment-name", configName));
            }
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        return String.format(AZURE_ENDPOINT_URL_PATTERN, resourceName.get(), deploymentName.get());
    }

    private LangChain4jAzureOpenAiConfig.AzureAiConfig correspondingAzureOpenAiConfig(LangChain4jAzureOpenAiConfig runtimeConfig, String configName) {
        LangChain4jAzureOpenAiConfig.AzureAiConfig azureAiConfig = NamedConfigUtil.isDefault((String)configName) ? runtimeConfig.defaultConfig() : runtimeConfig.namedConfig().get(configName);
        return azureAiConfig;
    }

    private void throwIfApiKeysNotConfigured(String apiKey, String adToken, String configName) {
        if (apiKey != null == (adToken != null)) {
            throw new ConfigValidationException(this.createKeyMisconfigurationProblem(configName));
        }
    }

    private ConfigValidationException.Problem[] createKeyMisconfigurationProblem(String configName) {
        return new ConfigValidationException.Problem[]{new ConfigValidationException.Problem(String.format("SRCFG00014: Exactly of the configuration properties must be present: quarkus.langchain4j.azure-openai%s%s or quarkus.langchain4j.azure-openai%s%s", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", "api-key", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", "ad-token"))};
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.azure-openai%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }

    public void cleanUp(ShutdownContext shutdown) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusOpenAiClient.clearCache();
            }
        });
    }
}

