/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.anthropic;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicDelta;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicStreamingData;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolResultContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolUseContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClientBuilderFactory;
import dev.langchain4j.model.anthropic.internal.client.AnthropicHttpException;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.anthropic.AnthropicRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

public class QuarkusAnthropicClient
extends AnthropicClient {
    public static final String BETA = "tools-2024-04-04";
    private final String apiKey;
    private final String anthropicVersion;
    private final AnthropicRestApi restApi;

    public QuarkusAnthropicClient(Builder builder) {
        this.apiKey = builder.apiKey;
        this.anthropicVersion = builder.version;
        try {
            QuarkusRestClientBuilder restApiBuilder = QuarkusRestClientBuilder.newBuilder().baseUri(new URI(builder.baseUrl)).connectTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(builder.timeout.toSeconds(), TimeUnit.SECONDS);
            if (builder.logRequests.booleanValue() || builder.logResponses.booleanValue()) {
                restApiBuilder.loggingScope(LoggingScope.REQUEST_RESPONSE).clientLogger((ClientLogger)new AnthropicClientLogger(builder.logRequests, builder.logResponses));
            }
            this.restApi = (AnthropicRestApi)restApiBuilder.build(AnthropicRestApi.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest request) {
        return this.restApi.createMessage(request, this.createMetadata(request));
    }

    public void createMessage(AnthropicCreateMessageRequest request, StreamingResponseHandler<AiMessage> handler) {
        this.restApi.streamMessage(request, this.createMetadata(request)).subscribe().withSubscriber((MultiSubscriber)new AnthropicStreamingSubscriber(handler));
    }

    private AnthropicRestApi.ApiMetadata createMetadata(AnthropicCreateMessageRequest request) {
        AnthropicRestApi.ApiMetadata.Builder builder = AnthropicRestApi.ApiMetadata.builder().apiKey(this.apiKey).anthropicVersion(this.anthropicVersion);
        if (this.hasTools(request)) {
            builder.beta(BETA);
        }
        return builder.build();
    }

    private boolean hasTools(AnthropicCreateMessageRequest request) {
        if (!Utils.isNullOrEmpty((Collection)request.getTools())) {
            return true;
        }
        List messages = request.getMessages();
        for (AnthropicMessage message : messages) {
            List contents = message.content;
            for (AnthropicMessageContent content : contents) {
                if (!(content instanceof AnthropicToolUseContent) && !(content instanceof AnthropicToolResultContent)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Builder
    extends AnthropicClient.Builder<QuarkusAnthropicClient, Builder> {
        public QuarkusAnthropicClient build() {
            return new QuarkusAnthropicClient(this);
        }
    }

    static class AnthropicClientLogger
    implements ClientLogger {
        private static final Logger log = Logger.getLogger(AnthropicClientLogger.class);
        private final boolean logRequests;
        private final boolean logResponses;

        public AnthropicClientLogger(boolean logRequests, boolean logResponses) {
            this.logRequests = logRequests;
            this.logResponses = logResponses;
        }

        public void setBodySize(int bodySize) {
        }

        public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
            if (this.logRequests && log.isInfoEnabled()) {
                try {
                    log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to log request", (Throwable)e);
                }
            }
        }

        public void logResponse(final HttpClientResponse response, boolean redirect) {
            if (this.logResponses && log.isInfoEnabled()) {
                response.bodyHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer body) {
                        try {
                            log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.inOneLine(response.headers()), (Object)this.bodyToString(body));
                        }
                        catch (Exception e) {
                            log.warn((Object)"Failed to log response", (Throwable)e);
                        }
                    }
                });
            }
        }

        private String bodyToString(Buffer body) {
            return body != null ? body.toString() : "";
        }

        private String inOneLine(MultiMap headers) {
            return StreamSupport.stream(headers.spliterator(), false).map(header -> {
                String headerKey = (String)header.getKey();
                String headerValue = (String)header.getValue();
                if (headerKey.equals("x-api-key")) {
                    headerValue = AnthropicClientLogger.maskApiKeyHeaderValue(headerValue);
                }
                return "[%s: %s]".formatted(headerKey, headerValue);
            }).collect(Collectors.joining(", "));
        }

        private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
            try {
                if (apiKeyHeaderValue.length() <= 4) {
                    return apiKeyHeaderValue;
                }
                return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
            }
            catch (Exception e) {
                return "Failed to mask the API key.";
            }
        }
    }

    private static class AnthropicStreamingSubscriber
    implements MultiSubscriber<AnthropicStreamingData> {
        private final StreamingResponseHandler<AiMessage> handler;
        private Flow.Subscription subscription;
        private volatile AtomicReference<StringBuffer> contentBuilder = new AtomicReference<StringBuffer>(new StringBuffer());
        private volatile String stopReason;
        private final List<String> contents = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger inputTokenCount = new AtomicInteger();
        private final AtomicInteger outputTokenCount = new AtomicInteger();

        private AnthropicStreamingSubscriber(StreamingResponseHandler<AiMessage> handler) {
            this.handler = handler;
        }

        public void onItem(AnthropicStreamingData data) {
            switch (data.type) {
                case "message_start": {
                    this.handleMessageStart(data);
                    break;
                }
                case "content_block_start": {
                    this.handleContentBlockStart(data);
                    break;
                }
                case "content_block_delta": {
                    this.handleContentBlockDelta(data);
                    break;
                }
                case "content_block_stop": {
                    this.handleContentBlockStop();
                    break;
                }
                case "message_delta": {
                    this.handleMessageDelta(data);
                    break;
                }
                case "message_stop": {
                    this.handleMessageStop();
                    break;
                }
                case "error": {
                    this.handleError(data);
                }
            }
        }

        private void handleMessageStart(AnthropicStreamingData data) {
            if (data.message != null && data.message.usage != null) {
                this.handleUsage(data.message.usage);
            }
        }

        private void handleUsage(AnthropicUsage usage) {
            if (usage.inputTokens != null) {
                this.inputTokenCount.addAndGet(usage.inputTokens);
            }
            if (usage.outputTokens != null) {
                this.outputTokenCount.addAndGet(usage.outputTokens);
            }
        }

        private void handleContentBlockStart(AnthropicStreamingData data) {
            String text;
            if (data.contentBlock != null && "text".equals(data.contentBlock.type) && Utils.isNotNullOrEmpty((String)(text = data.contentBlock.text))) {
                this.contentBuilder.get().append(text);
                this.handler.onNext(text);
            }
        }

        private void handleContentBlockDelta(AnthropicStreamingData data) {
            String text;
            if (data.delta != null && "text_delta".equals(data.delta.type) && Utils.isNotNullOrEmpty((String)(text = data.delta.text))) {
                this.contentBuilder.get().append(text);
                this.handler.onNext(text);
            }
        }

        private void handleContentBlockStop() {
            this.contents.add(this.contentBuilder.get().toString());
            this.contentBuilder.set(new StringBuffer());
        }

        private void handleMessageDelta(AnthropicStreamingData data) {
            if (data.delta != null) {
                AnthropicDelta delta = data.delta;
                if (delta.stopReason != null) {
                    this.stopReason = delta.stopReason;
                }
            }
            if (data.usage != null) {
                this.handleUsage(data.usage);
            }
        }

        private void handleMessageStop() {
            Response response = Response.from((Object)AiMessage.from((String)String.join((CharSequence)"\n", this.contents)), (TokenUsage)new TokenUsage(Integer.valueOf(this.inputTokenCount.get()), Integer.valueOf(this.outputTokenCount.get())), (FinishReason)AnthropicMapper.toFinishReason((String)this.stopReason));
            this.handler.onComplete(response);
        }

        private void handleError(AnthropicStreamingData data) {
            this.onFailure((Throwable)new AnthropicHttpException(null, "Got error processing data (%s)".formatted(data)));
        }

        public void onFailure(Throwable failure) {
            this.handler.onError(failure);
        }

        public void onCompletion() {
            this.handleMessageStop();
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(Long.MAX_VALUE);
        }
    }

    public static class QuarkusAnthropicClientBuilderFactory
    implements AnthropicClientBuilderFactory {
        public AnthropicClient.Builder get() {
            return new Builder();
        }
    }
}

