/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.anthropic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicStreamingData;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.smallrye.mutiny.Multi;
import jakarta.annotation.Priority;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;

@Path(value="")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RegisterProviders(value={@RegisterProvider(value=AnthropicRestApiJacksonReader.class), @RegisterProvider(value=AnthropicRestApiJacksonWriter.class), @RegisterProvider(value=AnthropicRestApiWriterInterceptor.class)})
public interface AnthropicRestApi {
    public static final String API_KEY_HEADER = "x-api-key";

    @Path(value="/messages")
    @POST
    public AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest var1, @BeanParam ApiMetadata var2);

    @Path(value="/messages")
    @POST
    @RestStreamElementType(value="application/json")
    public Multi<AnthropicStreamingData> streamMessage(AnthropicCreateMessageRequest var1, @BeanParam ApiMetadata var2);

    public static class ObjectMapperHolder {
        public static final ObjectMapper MAPPER = QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
        private static final ObjectReader READER = MAPPER.reader();
    }

    @Priority(value=5100)
    public static class AnthropicRestApiJacksonWriter
    implements MessageBodyWriter<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(ObjectMapperHolder.MAPPER.writeValueAsString(o).getBytes(StandardCharsets.UTF_8));
        }
    }

    @Priority(value=4900)
    public static class AnthropicRestApiJacksonReader
    extends AbstractJsonMessageBodyReader {
        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return ObjectMapperHolder.READER.forType(ObjectMapperHolder.READER.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
    }

    public static class AnthropicRestApiWriterInterceptor
    implements WriterInterceptor {
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            Object entity = context.getEntity();
            if (entity instanceof AnthropicCreateMessageRequest) {
                AnthropicCreateMessageRequest request = (AnthropicCreateMessageRequest)entity;
                MultivaluedMap headers = context.getHeaders();
                List acceptList = (List)headers.get((Object)"Accept");
                if (acceptList != null && acceptList.size() == 1) {
                    Object accept = acceptList.get(0);
                    if ("application/json".equals(accept)) {
                        if (Boolean.TRUE.equals(request.isStream())) {
                            context.setEntity((Object)request.toBuilder().stream(false).build());
                        }
                    } else if ("text/event-stream".equals(accept) && !Boolean.TRUE.equals(request.isStream())) {
                        context.setEntity((Object)request.toBuilder().stream(true).build());
                    }
                }
            }
            context.proceed();
        }
    }

    public static class ApiMetadata {
        @HeaderParam(value="x-api-key")
        public final String apiKey;
        @HeaderParam(value="anthropic-version")
        public final String anthropicVersion;
        @HeaderParam(value="anthropic-beta")
        public final String beta;

        private ApiMetadata(String apiKey, String anthropicVersion, String beta) {
            if (apiKey == null || apiKey.isBlank()) {
                throw new IllegalArgumentException("apiKey cannot be null or blank");
            }
            if (anthropicVersion == null || anthropicVersion.isBlank()) {
                throw new IllegalArgumentException("anthropicVersion cannot be null or blank");
            }
            this.apiKey = apiKey;
            this.anthropicVersion = anthropicVersion;
            this.beta = beta;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String apiKey;
            private String anthropicVersion;
            private String beta;

            public ApiMetadata build() {
                return new ApiMetadata(this.apiKey, this.anthropicVersion, this.beta);
            }

            public Builder apiKey(String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            public Builder anthropicVersion(String anthropicVersion) {
                this.anthropicVersion = anthropicVersion;
                return this;
            }

            public Builder beta(String beta) {
                this.beta = beta;
                return this;
            }
        }
    }
}

