/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.errors;

import java.util.Optional;

public class ErrorHandlingStrategy {
    public static final String CONTINUE = "continue";
    public static final String DEAD_LETTER_QUEUE = "dead-letter-queue";
    public static final String FAIL = "fail";

    public static boolean shouldSendToDlq(String errorStrategy, Optional<String> dlqTopic) {
        if (DEAD_LETTER_QUEUE.equals(errorStrategy)) {
            if (dlqTopic.isPresent()) {
                return true;
            }
            throw new IllegalStateException("DLQ strategy enabled but kafkastreamsprocessor.dlq.topic configuration property is missing");
        }
        return false;
    }

    private ErrorHandlingStrategy() {
    }
}

