/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.processor.AbstractProcessorDecorator;
import io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor.RetryDecoratorDelegate;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.kafka.streams.processor.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=600)
@Dependent
public class RetryDecorator
extends AbstractProcessorDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryDecorator.class);
    private final RetryDecoratorDelegate retryDecoratorDelegate;

    @Inject
    public RetryDecorator(RetryDecoratorDelegate retryDecoratorDelegate) {
        this.retryDecoratorDelegate = retryDecoratorDelegate;
    }

    public void process(Record record) {
        try {
            this.retryDecoratorDelegate.retryableProcess(this.getDelegate(), record);
        }
        catch (RuntimeException e) {
            log.info("An exception that has been raised by the processor will not be retried.\nPossible causes:\n- That's not a managed retryable exception\n- max-retries or max-duration limits have been reached");
            throw e;
        }
    }

    private static interface Excludes {
        public <KIn, VIn> void process(Record<KIn, VIn> var1);
    }
}

