/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.outputrecord.OutputRecordInterceptor;
import io.quarkiverse.kafkastreamsprocessor.api.decorator.processor.AbstractProcessorDecorator;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.CommitCallback;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.ToInternal;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.internals.ThreadCache;

@Dependent
@Priority(value=250)
public class OutputRecordInterceptionDecorator
extends AbstractProcessorDecorator {
    private final List<OutputRecordInterceptor> outputRecordInterceptors;

    @Inject
    public OutputRecordInterceptionDecorator(Instance<OutputRecordInterceptor> forwardDecorators) {
        this.outputRecordInterceptors = forwardDecorators.stream().collect(Collectors.toList());
        Collections.sort(this.outputRecordInterceptors, Comparator.comparingInt(OutputRecordInterceptor::priority));
    }

    public void init(ProcessorContext context) {
        this.getDelegate().init((ProcessorContext)new ContextForwardProcessorContextDecorator((InternalProcessorContext)context, this.outputRecordInterceptors));
    }

    public static class ContextForwardProcessorContextDecorator
    implements InternalProcessorContext {
        private final InternalProcessorContext delegate;
        private final List<OutputRecordInterceptor> outputRecordInterceptors;

        public <K, V> void forward(K key, V value) {
            Record toForward = new Record(key, value, this.timestamp(), this.headers());
            this.forward(toForward);
        }

        public <K, V> void forward(K key, V value, To to) {
            ToInternal toInternal = new ToInternal(to);
            Record toForward = new Record(key, value, toInternal.hasTimestamp() ? toInternal.timestamp() : this.timestamp(), this.headers());
            this.forward(toForward, toInternal.child());
        }

        public void forward(FixedKeyRecord record) {
            this.forward(new Record(record.key(), record.value(), record.timestamp(), record.headers()));
        }

        public void forward(FixedKeyRecord record, String childName) {
            this.forward(new Record(record.key(), record.value(), record.timestamp(), record.headers()), childName);
        }

        public void forward(Record record) {
            this.forward(record, null);
        }

        public void forward(Record record, String childName) {
            for (OutputRecordInterceptor outputRecordInterceptor : this.outputRecordInterceptors) {
                record = outputRecordInterceptor.interceptOutputRecord(record);
            }
            this.delegate.forward(record, childName);
        }

        public void setCurrentNode(ProcessorNode currentNode) {
            this.delegate.setCurrentNode(currentNode);
        }

        @Generated
        public ContextForwardProcessorContextDecorator(InternalProcessorContext delegate, List<OutputRecordInterceptor> outputRecordInterceptors) {
            this.delegate = delegate;
            this.outputRecordInterceptors = outputRecordInterceptors;
        }

        @Generated
        public StreamsMetricsImpl metrics() {
            return this.delegate.metrics();
        }

        @Generated
        public void setSystemTimeMs(long arg0) {
            this.delegate.setSystemTimeMs(arg0);
        }

        @Generated
        public ProcessorRecordContext recordContext() {
            return this.delegate.recordContext();
        }

        @Generated
        public void setRecordContext(ProcessorRecordContext arg0) {
            this.delegate.setRecordContext(arg0);
        }

        @Generated
        public ProcessorNode currentNode() {
            return this.delegate.currentNode();
        }

        @Generated
        public ThreadCache cache() {
            return this.delegate.cache();
        }

        @Generated
        public void initialize() {
            this.delegate.initialize();
        }

        @Generated
        public void uninitialize() {
            this.delegate.uninitialize();
        }

        @Generated
        public Task.TaskType taskType() {
            return this.delegate.taskType();
        }

        @Generated
        public void transitionToActive(StreamTask arg0, RecordCollector arg1, ThreadCache arg2) {
            this.delegate.transitionToActive(arg0, arg1, arg2);
        }

        @Generated
        public void transitionToStandby(ThreadCache arg0) {
            this.delegate.transitionToStandby(arg0);
        }

        @Generated
        public void registerCacheFlushListener(String arg0, ThreadCache.DirtyEntryFlushListener arg1) {
            this.delegate.registerCacheFlushListener(arg0, arg1);
        }

        @Generated
        public StateStore getStateStore(StoreBuilder builder) {
            return this.delegate.getStateStore(builder);
        }

        @Generated
        public void logChange(String arg0, Bytes arg1, byte[] arg2, long arg3, Position arg4) {
            this.delegate.logChange(arg0, arg1, arg2, arg3, arg4);
        }

        @Generated
        public String changelogFor(String arg0) {
            return this.delegate.changelogFor(arg0);
        }

        @Generated
        public void addProcessorMetadataKeyValue(String arg0, long arg1) {
            this.delegate.addProcessorMetadataKeyValue(arg0, arg1);
        }

        @Generated
        public Long processorMetadataForKey(String arg0) {
            return this.delegate.processorMetadataForKey(arg0);
        }

        @Generated
        public void setProcessorMetadata(ProcessorMetadata arg0) {
            this.delegate.setProcessorMetadata(arg0);
        }

        @Generated
        public ProcessorMetadata getProcessorMetadata() {
            return this.delegate.getProcessorMetadata();
        }

        @Generated
        public String applicationId() {
            return this.delegate.applicationId();
        }

        @Generated
        public TaskId taskId() {
            return this.delegate.taskId();
        }

        @Generated
        public Serde<?> keySerde() {
            return this.delegate.keySerde();
        }

        @Generated
        public Serde<?> valueSerde() {
            return this.delegate.valueSerde();
        }

        @Generated
        public File stateDir() {
            return this.delegate.stateDir();
        }

        @Generated
        public void register(StateStore arg0, StateRestoreCallback arg1) {
            this.delegate.register(arg0, arg1);
        }

        @Generated
        public <S extends StateStore> S getStateStore(String arg0) {
            return (S)this.delegate.getStateStore(arg0);
        }

        @Generated
        public Cancellable schedule(Duration arg0, PunctuationType arg1, Punctuator arg2) {
            return this.delegate.schedule(arg0, arg1, arg2);
        }

        @Generated
        public void commit() {
            this.delegate.commit();
        }

        @Generated
        public String topic() {
            return this.delegate.topic();
        }

        @Generated
        public int partition() {
            return this.delegate.partition();
        }

        @Generated
        public long offset() {
            return this.delegate.offset();
        }

        @Generated
        public Headers headers() {
            return this.delegate.headers();
        }

        @Generated
        public long timestamp() {
            return this.delegate.timestamp();
        }

        @Generated
        public Map<String, Object> appConfigs() {
            return this.delegate.appConfigs();
        }

        @Generated
        public Map<String, Object> appConfigsWithPrefix(String arg0) {
            return this.delegate.appConfigsWithPrefix(arg0);
        }

        @Generated
        public long currentSystemTimeMs() {
            return this.delegate.currentSystemTimeMs();
        }

        @Generated
        public long currentStreamTimeMs() {
            return this.delegate.currentStreamTimeMs();
        }

        @Generated
        public Optional<RecordMetadata> recordMetadata() {
            return this.delegate.recordMetadata();
        }

        @Generated
        public void register(StateStore arg0, StateRestoreCallback arg1, CommitCallback arg2) {
            this.delegate.register(arg0, arg1, arg2);
        }

        private static interface Excludes {
            public <K, V> void forward(K var1, V var2);

            public <K, V> void forward(K var1, V var2, To var3);

            public void forward(FixedKeyRecord var1);

            public void forward(FixedKeyRecord var1, String var2);

            public void forward(Record var1);

            public void forward(Record var1, String var2);

            public void setCurrentNode(ProcessorNode var1);
        }
    }
}

